/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.java2d.CubicSegment;
import gnu.java.awt.java2d.LineSegment;
import gnu.java.awt.java2d.QuadSegment;
import gnu.java.awt.java2d.Segment;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class BasicStroke
implements Stroke {
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private final float width;
    private final int cap;
    private final int join;
    private final float limit;
    private final float[] dash;
    private final float phase;
    private Segment start;
    private Segment end;

    public BasicStroke(float width, int cap, int join, float miterlimit, float[] dash, float dashPhase) {
        if (width < 0.0f) {
            throw new IllegalArgumentException("width " + width + " < 0");
        }
        if (cap < 0 || cap > 2) {
            throw new IllegalArgumentException("cap " + cap + " out of range [" + 0 + ".." + 2 + "]");
        }
        if (miterlimit < 1.0f && join == 0) {
            throw new IllegalArgumentException("miterlimit " + miterlimit + " < 1.0f while join == JOIN_MITER");
        }
        if (join < 0 || join > 2) {
            throw new IllegalArgumentException("join " + join + " out of range [" + 0 + ".." + 2 + "]");
        }
        if (dashPhase < 0.0f && dash != null) {
            throw new IllegalArgumentException("dashPhase " + dashPhase + " < 0.0f while dash != null");
        }
        if (dash != null) {
            if (dash.length == 0) {
                throw new IllegalArgumentException("dash.length is 0");
            }
            boolean allZero = true;
            int i = 0;
            while (i < dash.length) {
                if (dash[i] != 0.0f) {
                    allZero = false;
                    break;
                }
                ++i;
            }
            if (allZero) {
                throw new IllegalArgumentException("all dashes are 0.0f");
            }
        }
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.limit = miterlimit;
        this.dash = dash == null ? null : (float[])dash.clone();
        this.phase = dashPhase;
    }

    public BasicStroke(float width, int cap, int join, float miterlimit) {
        this(width, cap, join, miterlimit, null, 0.0f);
    }

    public BasicStroke(float width, int cap, int join) {
        this(width, cap, join, 10.0f, null, 0.0f);
    }

    public BasicStroke(float width) {
        this(width, 2, 0, 10.0f, null, 0.0f);
    }

    public BasicStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }

    public Shape createStrokedShape(Shape s) {
        PathIterator pi = s.getPathIterator(null);
        if (this.dash == null) {
            return this.solidStroke(pi);
        }
        return this.dashedStroke(pi);
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.limit;
    }

    public float[] getDashArray() {
        return this.dash;
    }

    public float getDashPhase() {
        return this.phase;
    }

    public int hashCode() {
        int hash = Float.floatToIntBits(this.width);
        hash ^= this.cap;
        hash ^= this.join;
        hash ^= Float.floatToIntBits(this.limit);
        if (this.dash != null) {
            int i = 0;
            while (i < this.dash.length) {
                hash ^= Float.floatToIntBits(this.dash[i]);
                ++i;
            }
        }
        return hash ^= Float.floatToIntBits(this.phase);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicStroke)) {
            return false;
        }
        BasicStroke s = (BasicStroke)o;
        return this.width == s.width && this.cap == s.cap && this.join == s.join && this.limit == s.limit && Arrays.equals(this.dash, s.dash) && this.phase == s.phase;
    }

    private Shape solidStroke(PathIterator pi) {
        double[] coords = new double[6];
        boolean pathOpen = false;
        GeneralPath output = new GeneralPath();
        double y0 = 0.0;
        double y = 0.0;
        double x0 = 0.0;
        double x = 0.0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    x0 = x = coords[0];
                    y0 = y = coords[1];
                    if (!pathOpen) break;
                    this.capEnds();
                    this.convertPath(output, this.start);
                    this.end = null;
                    this.start = null;
                    pathOpen = false;
                    break;
                }
                case 1: {
                    Segment[] p = new LineSegment(x, y, coords[0], coords[1]).getDisplacedSegments((double)this.width / 2.0);
                    if (!pathOpen) {
                        this.start = p[0];
                        this.end = p[1];
                        pathOpen = true;
                    } else {
                        this.addSegments(p);
                    }
                    x = coords[0];
                    y = coords[1];
                    break;
                }
                case 2: {
                    Segment[] p = new QuadSegment(x, y, coords[0], coords[1], coords[2], coords[3]).getDisplacedSegments((double)this.width / 2.0);
                    if (!pathOpen) {
                        this.start = p[0];
                        this.end = p[1];
                        pathOpen = true;
                    } else {
                        this.addSegments(p);
                    }
                    x = coords[2];
                    y = coords[3];
                    break;
                }
                case 3: {
                    Segment[] p = new CubicSegment(x, y, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]).getDisplacedSegments((double)this.width / 2.0);
                    if (!pathOpen) {
                        this.start = p[0];
                        this.end = p[1];
                        pathOpen = true;
                    } else {
                        this.addSegments(p);
                    }
                    x = coords[4];
                    y = coords[5];
                    break;
                }
                case 4: {
                    Segment[] p;
                    if (x == x0 && y == y0) {
                        this.joinSegments(new Segment[]{this.start.first, this.end.first});
                    } else {
                        p = new LineSegment(x, y, x0, y0).getDisplacedSegments((double)this.width / 2.0);
                        this.addSegments(p);
                    }
                    this.convertPath(output, this.start);
                    this.convertPath(output, this.end);
                    this.end = null;
                    this.start = null;
                    pathOpen = false;
                    output.setWindingRule(0);
                }
            }
            pi.next();
        }
        if (pathOpen) {
            this.capEnds();
            this.convertPath(output, this.start);
        }
        return output;
    }

    private Shape dashedStroke(PathIterator pi) {
        FlatteningPathIterator flat = new FlatteningPathIterator(pi, Math.sqrt(this.width / 3.0f));
        double[] coords = new double[2];
        double y = 0.0;
        double x = 0.0;
        boolean pathOpen = false;
        boolean dashOn = true;
        boolean offsetting = this.phase != 0.0f;
        double distance = 0.0;
        int dashIndex = 0;
        GeneralPath output = new GeneralPath();
        while (!flat.isDone()) {
            switch (flat.currentSegment(coords)) {
                case 0: {
                    double cfr_ignored_0 = coords[0];
                    double cfr_ignored_1 = coords[1];
                    if (!pathOpen) break;
                    this.capEnds();
                    this.convertPath(output, this.start);
                    this.end = null;
                    this.start = null;
                    pathOpen = false;
                    break;
                }
                case 1: {
                    boolean segmentConsumed = false;
                    while (!segmentConsumed) {
                        double segLength = Math.sqrt((x - coords[0]) * (x - coords[0]) + (y - coords[1]) * (y - coords[1]));
                        boolean spanBoundary = true;
                        double[] segmentEnd = null;
                        if (offsetting && distance + segLength <= (double)this.phase || distance + segLength <= (double)this.dash[dashIndex]) {
                            spanBoundary = false;
                        } else {
                            segmentEnd = (double[])coords.clone();
                            double reqLength = offsetting ? (double)this.phase - distance : (double)this.dash[dashIndex] - distance;
                            coords[0] = x + (coords[0] - x) * reqLength / segLength;
                            coords[1] = y + (coords[1] - y) * reqLength / segLength;
                        }
                        if (offsetting || !dashOn) {
                            double cfr_ignored_2 = coords[0];
                            double cfr_ignored_3 = coords[1];
                            if (pathOpen) {
                                this.capEnds();
                                this.convertPath(output, this.start);
                                this.end = null;
                                this.start = null;
                                pathOpen = false;
                            }
                        } else {
                            Segment[] p = new LineSegment(x, y, coords[0], coords[1]).getDisplacedSegments((double)this.width / 2.0);
                            if (!pathOpen) {
                                this.start = p[0];
                                this.end = p[1];
                                pathOpen = true;
                            } else {
                                this.addSegments(p);
                            }
                            x = coords[0];
                            y = coords[1];
                        }
                        if (!spanBoundary) {
                            distance += segLength;
                            segmentConsumed = true;
                            continue;
                        }
                        if (offsetting) {
                            offsetting = false;
                        }
                        dashOn = !dashOn;
                        distance = 0.0;
                        coords = segmentEnd;
                        if (dashIndex + 1 == this.dash.length) {
                            dashIndex = 0;
                            continue;
                        }
                        ++dashIndex;
                    }
                    break;
                }
            }
            flat.next();
        }
        if (pathOpen) {
            this.capEnds();
            this.convertPath(output, this.start);
        }
        return output;
    }

    private void capEnds() {
        Segment returnPath = this.end.last;
        this.end.reverseAll();
        this.end = null;
        this.capEnd(this.start, returnPath);
        this.start.last = returnPath.last;
        this.end = null;
        this.capEnd(this.start, this.start);
    }

    private void convertPath(GeneralPath p, Segment s) {
        Segment v = s;
        p.moveTo((float)s.P1.getX(), (float)s.P1.getY());
        do {
            if (v instanceof LineSegment) {
                p.lineTo((float)v.P2.getX(), (float)v.P2.getY());
                continue;
            }
            if (v instanceof QuadSegment) {
                p.quadTo((float)((QuadSegment)v).cp.getX(), (float)((QuadSegment)v).cp.getY(), (float)v.P2.getX(), (float)v.P2.getY());
                continue;
            }
            if (!(v instanceof CubicSegment)) continue;
            p.curveTo((float)((CubicSegment)v).cp1.getX(), (float)((CubicSegment)v).cp1.getY(), (float)((CubicSegment)v).cp2.getX(), (float)((CubicSegment)v).cp2.getY(), (float)v.P2.getX(), (float)v.P2.getY());
        } while ((v = v.next) != s && v != null);
        p.closePath();
    }

    private void addSegments(Segment[] segments) {
        this.joinSegments(segments);
        this.start.add(segments[0]);
        this.end.add(segments[1]);
    }

    private void joinSegments(Segment[] segments) {
        double[] p0 = this.start.last.cp2();
        double[] p1 = new double[]{this.start.last.P2.getX(), this.start.last.P2.getY()};
        double[] p2 = new double[]{segments[0].first.P1.getX(), segments[0].first.P1.getY()};
        double[] p3 = segments[0].cp1();
        Point2D p = this.lineIntersection(p0[0], p0[1], p1[0], p1[1], p2[0], p2[1], p3[0], p3[1], false);
        double det = (p1[0] - p0[0]) * (p3[1] - p2[1]) - (p3[0] - p2[0]) * (p1[1] - p0[1]);
        if (det > 0.0) {
            this.joinInnerSegments(this.start, segments[0], p);
            this.joinOuterSegments(this.end, segments[1], p);
        } else {
            this.joinInnerSegments(this.end, segments[1], p);
            this.joinOuterSegments(this.start, segments[0], p);
        }
    }

    private void capEnd(Segment a, Segment b) {
        switch (this.cap) {
            case 0: {
                a.add(new LineSegment(a.last.P2, b.P1));
                break;
            }
            case 2: {
                double[] p0 = a.last.cp2();
                double[] p1 = new double[]{a.last.P2.getX(), a.last.P2.getY()};
                double dx = p1[0] - p0[0];
                double dy = p1[1] - p0[1];
                double l = Math.sqrt(dx * dx + dy * dy);
                dx = 0.5 * (double)this.width * dx / l;
                dy = 0.5 * (double)this.width * dy / l;
                Point2D.Double c1 = new Point2D.Double(p1[0] + dx, p1[1] + dy);
                Point2D.Double c2 = new Point2D.Double(b.P1.getX() + dx, b.P1.getY() + dy);
                a.add(new LineSegment(a.last.P2, c1));
                a.add(new LineSegment(c1, c2));
                a.add(new LineSegment(c2, b.P1));
                break;
            }
            case 1: {
                double[] p0 = a.last.cp2();
                double[] p1 = new double[]{a.last.P2.getX(), a.last.P2.getY()};
                double dx = p1[0] - p0[0];
                double dy = p1[1] - p0[1];
                if (dx != 0.0 && dy != 0.0) {
                    double l = Math.sqrt(dx * dx + dy * dy);
                    dx = 0.6666666666666666 * (double)this.width * dx / l;
                    dy = 0.6666666666666666 * (double)this.width * dy / l;
                }
                Point2D.Double c1 = new Point2D.Double(p1[0] + dx, p1[1] + dy);
                Point2D.Double c2 = new Point2D.Double(b.P1.getX() + dx, b.P1.getY() + dy);
                a.add(new CubicSegment(a.last.P2, c1, c2, b.P1));
            }
        }
        a.add(b);
    }

    private Point2D lineIntersection(double X1, double Y1, double X2, double Y2, double X3, double Y3, double X4, double Y4, boolean infinite) {
        double x1 = X1;
        double y1 = Y1;
        double rx = X2 - x1;
        double ry = Y2 - y1;
        double x2 = X3;
        double y2 = Y3;
        double sx = X4 - x2;
        double sy = Y4 - y2;
        double determinant = sx * ry - sy * rx;
        double nom = sx * (y2 - y1) + sy * (x1 - x2);
        if (Math.abs(determinant) < 1.0E-6) {
            return null;
        }
        nom /= determinant;
        if (!infinite && (nom > 1.0 || nom < 0.0)) {
            return null;
        }
        return new Point2D.Double(x1 + nom * rx, y1 + nom * ry);
    }

    private void joinOuterSegments(Segment a, Segment b, Point2D insideP) {
        switch (this.join) {
            case 0: {
                double[] p0 = a.last.cp2();
                double[] p1 = new double[]{a.last.P2.getX(), a.last.P2.getY()};
                double[] p2 = new double[]{b.P1.getX(), b.P1.getY()};
                double[] p3 = b.cp1();
                Point2D p = this.lineIntersection(p0[0], p0[1], p1[0], p1[1], p2[0], p2[1], p3[0], p3[1], true);
                if (p == null || insideP == null) {
                    a.add(new LineSegment(a.last.P2, b.P1));
                    break;
                }
                if (p.distance(insideP) / (double)this.width < (double)this.limit) {
                    a.add(new LineSegment(a.last.P2, p));
                    a.add(new LineSegment(p, b.P1));
                    break;
                }
                a.add(new LineSegment(a.last.P2, b.P1));
                break;
            }
            case 1: {
                double[] p0 = a.last.cp2();
                double[] p1 = new double[]{a.last.P2.getX(), a.last.P2.getY()};
                double dx = p1[0] - p0[0];
                double dy = p1[1] - p0[1];
                double l = Math.sqrt(dx * dx + dy * dy);
                dx = 0.5 * (double)this.width * dx / l;
                dy = 0.5 * (double)this.width * dy / l;
                Point2D.Double c1 = new Point2D.Double(p1[0] + dx, p1[1] + dy);
                p0 = new double[]{b.P1.getX(), b.P1.getY()};
                p1 = b.cp1();
                dx = p0[0] - p1[0];
                dy = p0[1] - p1[1];
                l = Math.sqrt(dx * dx + dy * dy);
                dx = 0.5 * (double)this.width * dx / l;
                dy = 0.5 * (double)this.width * dy / l;
                Point2D.Double c2 = new Point2D.Double(p0[0] + dx, p0[1] + dy);
                a.add(new CubicSegment(a.last.P2, c1, c2, b.P1));
                break;
            }
            case 2: {
                a.add(new LineSegment(a.last.P2, b.P1));
            }
        }
    }

    private void joinInnerSegments(Segment a, Segment b, Point2D p) {
        a.last.cp2();
        double[] dArray = new double[]{a.last.P2.getX(), a.last.P2.getY()};
        double[] dArray2 = new double[]{b.P1.getX(), b.P1.getY()};
        b.cp1();
        if (p == null) {
            a.add(new LineSegment(a.last.P2, b.P1));
            p = new Point2D.Double((b.P1.getX() + a.last.P2.getX()) / 2.0, (b.P1.getY() + a.last.P2.getY()) / 2.0);
        } else {
            a.last.P2 = b.P1 = p;
        }
    }
}

