/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.VMNetworkInterface;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkInterface {
    private String name;
    private Vector<InetAddress> inetAddresses;

    NetworkInterface(String name, InetAddress address) {
        this.name = name;
        this.inetAddresses = new Vector(1, 1);
        this.inetAddresses.add(address);
    }

    NetworkInterface(String name, InetAddress[] addresses) {
        this.name = name;
        this.inetAddresses = new Vector(addresses.length, 1);
        int i = 0;
        while (i < addresses.length) {
            this.inetAddresses.add(addresses[i]);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        SecurityManager s = System.getSecurityManager();
        if (s == null) {
            return this.inetAddresses.elements();
        }
        Vector<InetAddress> tmpInetAddresses = new Vector<InetAddress>(1, 1);
        Enumeration<InetAddress> addresses = this.inetAddresses.elements();
        while (addresses.hasMoreElements()) {
            InetAddress addr = addresses.nextElement();
            try {
                s.checkConnect(addr.getHostAddress(), 58000);
                tmpInetAddresses.add(addr);
            }
            catch (SecurityException securityException) {}
        }
        return tmpInetAddresses.elements();
    }

    public String getDisplayName() {
        return this.name;
    }

    public static NetworkInterface getByName(String name) throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface tmp = e.nextElement();
            if (!name.equals(tmp.getName())) continue;
            return tmp;
        }
        return null;
    }

    public static NetworkInterface getByInetAddress(InetAddress addr) throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface tmp = interfaces.nextElement();
            Enumeration<InetAddress> addresses = tmp.inetAddresses.elements();
            while (addresses.hasMoreElements()) {
                if (!addr.equals(addresses.nextElement())) continue;
                return tmp;
            }
        }
        throw new SocketException("no network interface is bound to such an IP address");
    }

    private static Collection condense(Collection interfaces) {
        HashMap<String, NetworkInterface> condensed = new HashMap<String, NetworkInterface>();
        for (NetworkInterface face : interfaces) {
            String name = face.getName();
            if (condensed.containsKey(name)) {
                NetworkInterface conface = (NetworkInterface)condensed.get(name);
                if (conface.inetAddresses.containsAll(face.inetAddresses)) continue;
                for (InetAddress faceAddress : face.inetAddresses) {
                    if (conface.inetAddresses.contains(faceAddress)) continue;
                    conface.inetAddresses.add(faceAddress);
                }
                continue;
            }
            condensed.put(name, face);
        }
        return condensed.values();
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        Vector networkInterfaces = VMNetworkInterface.getInterfaces();
        if (networkInterfaces.isEmpty()) {
            return null;
        }
        Collection condensed = NetworkInterface.condense(networkInterfaces);
        return Collections.enumeration(condensed);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface tmp = (NetworkInterface)obj;
        return this.name.equals(tmp.name) && this.inetAddresses.equals(tmp.inetAddresses);
    }

    public int hashCode() {
        return this.name.hashCode() + this.inetAddresses.hashCode();
    }

    public String toString() {
        String separator = System.getProperty("line.separator");
        String result = "name: " + this.getDisplayName() + " (" + this.getName() + ") addresses:" + separator;
        Enumeration<InetAddress> e = this.inetAddresses.elements();
        while (e.hasMoreElements()) {
            InetAddress address = e.nextElement();
            result = String.valueOf(result) + address.toString() + ";" + separator;
        }
        return result;
    }
}

