/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import gnu.classpath.NotImplementedException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;

public class KerberosTicket
implements Destroyable,
Serializable,
Refreshable {
    private static final long serialVersionUID = 7395334370157380539L;
    private static final int FORWARDABLE = 1;
    private static final int FORWARDED = 2;
    private static final int PROXIABLE = 3;
    private static final int PROXY = 4;
    private static final int POSTDATED = 6;
    private static final int RENEWABLE = 8;
    private static final int INITIAL = 9;
    private static final int NUM_FLAGS = 12;
    private byte[] asn1Encoding;
    private KeyImpl sessionKey;
    private boolean[] flags;
    private Date authTime;
    private Date startTime;
    private Date endTime;
    private Date renewTill;
    private KerberosPrincipal client;
    private KerberosPrincipal server;
    private InetAddress[] clientAddresses;

    public KerberosTicket(byte[] asn1Encoding, KerberosPrincipal client, KerberosPrincipal server, byte[] key, int type, boolean[] flags, Date authTime, Date startTime, Date endTime, Date renewTill, InetAddress[] clientAddresses) {
        this.asn1Encoding = (byte[])asn1Encoding.clone();
        this.sessionKey = new KeyImpl(key, type);
        this.flags = new boolean[12];
        if (flags != null) {
            System.arraycopy(flags, 0, this.flags, 0, Math.min(flags.length, 12));
        }
        this.flags = (boolean[])flags.clone();
        this.authTime = (Date)authTime.clone();
        this.startTime = (Date)(startTime == null ? authTime : startTime).clone();
        this.endTime = (Date)endTime.clone();
        this.renewTill = (Date)renewTill.clone();
        this.client = client;
        this.server = server;
        this.clientAddresses = clientAddresses == null ? null : (InetAddress[])clientAddresses.clone();
    }

    public void destroy() throws DestroyFailedException {
        if (this.sessionKey == null) {
            throw new DestroyFailedException("already destroyed");
        }
        this.sessionKey = null;
        this.asn1Encoding = null;
    }

    public boolean isDestroyed() {
        return this.sessionKey == null;
    }

    public boolean isCurrent() {
        long now = System.currentTimeMillis();
        return this.startTime.getTime() <= now && now <= this.endTime.getTime();
    }

    public void refresh() throws RefreshFailedException, NotImplementedException {
        if (!this.isRenewable()) {
            throw new RefreshFailedException("not renewable");
        }
        if (this.renewTill != null && System.currentTimeMillis() >= this.renewTill.getTime()) {
            throw new RefreshFailedException("renewal time elapsed");
        }
        throw new RefreshFailedException("not implemented");
    }

    public final KerberosPrincipal getClient() {
        return this.client;
    }

    public final KerberosPrincipal getServer() {
        return this.server;
    }

    public final boolean isForwardable() {
        return this.flags[1];
    }

    public final boolean isForwarded() {
        return this.flags[2];
    }

    public final boolean isProxiable() {
        return this.flags[3];
    }

    public final boolean isProxy() {
        return this.flags[4];
    }

    public final boolean isPostdated() {
        return this.flags[6];
    }

    public final boolean isRenewable() {
        return this.flags[8];
    }

    public final boolean isInitial() {
        return this.flags[9];
    }

    public final boolean[] getFlags() {
        return (boolean[])this.flags.clone();
    }

    public final Date getAuthTime() {
        return (Date)this.authTime.clone();
    }

    public final Date getStartTime() {
        return (Date)this.startTime.clone();
    }

    public final Date getEndTime() {
        return (Date)this.endTime.clone();
    }

    public final Date getRenewTill() {
        return this.flags[8] ? (Date)this.renewTill.clone() : null;
    }

    public final InetAddress[] getClientAddresses() {
        return this.clientAddresses == null ? null : (InetAddress[])this.clientAddresses.clone();
    }

    public final byte[] getEncoded() {
        this.checkDestroyed();
        return (byte[])this.sessionKey.key.clone();
    }

    public final SecretKey getSessionKey() {
        this.checkDestroyed();
        return this.sessionKey;
    }

    private void checkDestroyed() {
        if (this.sessionKey == null) {
            throw new IllegalStateException("key is destroyed");
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[client=" + this.client + ",server=" + this.server + ",sessionKey=" + this.sessionKey + ",flags=" + this.flags + ",authTime=" + this.authTime + ",startTime= " + this.startTime + ",endTime=" + this.endTime + ",renewTill=" + this.renewTill + ",clientAddresses=" + this.clientAddresses + "]";
    }

    public final int getSessionKeyType() {
        return this.sessionKey.type;
    }
}

