/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang;

import gnu.classpath.SystemProperties;
import gnu.java.lang.VMCPStringBuilder;
import java.io.Serializable;

public final class CPStringBuilder
implements Serializable,
CharSequence,
Appendable {
    private int count;
    private char[] value;
    private boolean allocated = false;
    private static final int DEFAULT_CAPACITY;

    static {
        String cap = SystemProperties.getProperty("gnu.classpath.cpstringbuilder.capacity");
        DEFAULT_CAPACITY = cap == null ? 32 : Integer.parseInt(cap);
    }

    public CPStringBuilder() {
        this(DEFAULT_CAPACITY);
    }

    public CPStringBuilder(int capacity) {
        this.value = new char[capacity];
    }

    public CPStringBuilder(String str) {
        this.count = str.length();
        this.value = new char[this.count + DEFAULT_CAPACITY];
        str.getChars(0, this.count, this.value, 0);
    }

    public CPStringBuilder(StringBuffer str) {
        this.count = str.length();
        this.value = new char[this.count + DEFAULT_CAPACITY];
        str.getChars(0, this.count, this.value, 0);
    }

    public CPStringBuilder(StringBuilder str) {
        this.count = str.length();
        this.value = new char[this.count + DEFAULT_CAPACITY];
        str.getChars(0, this.count, this.value, 0);
    }

    public CPStringBuilder(CharSequence seq) {
        int len = seq.length();
        this.count = len <= 0 ? 0 : len;
        this.value = new char[this.count + DEFAULT_CAPACITY];
        int i = 0;
        while (i < len) {
            this.value[i] = seq.charAt(i);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setLength(int newLength) {
        block3: {
            if (newLength < 0) {
                throw new StringIndexOutOfBoundsException(newLength);
            }
            valueLength = this.value.length;
            if (newLength > 0) {
                this.ensureCapacity(newLength);
            }
            if (newLength >= valueLength) ** GOTO lbl10
            this.count = newLength;
            break block3;
lbl-1000:
            // 1 sources

            {
                this.value[this.count++] = '\u0000';
lbl10:
                // 2 sources

                ** while (this.count < newLength)
            }
        }
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public int codePointAt(int index) {
        return Character.codePointAt(this.value, index, this.count);
    }

    public int codePointBefore(int index) {
        if (index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointBefore(this.value, index, 1);
    }

    public void getChars(int srcOffset, int srcEnd, char[] dst, int dstOffset) {
        if (srcOffset < 0 || srcEnd > this.count || srcEnd < srcOffset) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, srcOffset, dst, dstOffset, srcEnd - srcOffset);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.ensureCapacity(this.count);
        this.value[index] = ch;
    }

    public CPStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public CPStringBuilder append(String str) {
        if (str == null) {
            str = "null";
        }
        int len = str.length();
        this.ensureCapacity(this.count + len);
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPStringBuilder append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int len = stringBuffer.length();
            this.ensureCapacity(this.count + len);
            stringBuffer.getChars(0, len, this.value, this.count);
            this.count += len;
        }
        return this;
    }

    public CPStringBuilder append(char[] data) {
        return this.append(data, 0, data.length);
    }

    public CPStringBuilder append(char[] data, int offset, int count) {
        if (offset < 0 || count < 0 || offset > data.length - count) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + count);
        System.arraycopy(data, offset, this.value, this.count, count);
        this.count += count;
        return this;
    }

    public CPStringBuilder append(boolean bool) {
        return this.append(bool ? "true" : "false");
    }

    public CPStringBuilder append(char ch) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = ch;
        return this;
    }

    public CPStringBuilder append(CharSequence seq) {
        return this.append(seq, 0, seq.length());
    }

    public CPStringBuilder append(CharSequence seq, int start, int end) {
        if (seq == null) {
            return this.append("null");
        }
        if (end - start > 0) {
            this.ensureCapacity(this.count + end - start);
            while (start < end) {
                this.value[this.count++] = seq.charAt(start);
                ++start;
            }
        }
        return this;
    }

    public CPStringBuilder append(int inum) {
        return this.append(String.valueOf(inum));
    }

    public CPStringBuilder append(long lnum) {
        return this.append(Long.toString(lnum, 10));
    }

    public CPStringBuilder append(float fnum) {
        return this.append(Float.toString(fnum));
    }

    public CPStringBuilder append(double dnum) {
        return this.append(Double.toString(dnum));
    }

    public CPStringBuilder appendCodePoint(int code) {
        int len = Character.charCount(code);
        this.ensureCapacity(this.count + len);
        Character.toChars(code, this.value, this.count);
        this.count += len;
        return this;
    }

    public CPStringBuilder delete(int start, int end) {
        if (start < 0 || start > this.count || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        this.ensureCapacity(this.count);
        if (this.count - end != 0) {
            System.arraycopy(this.value, end, this.value, start, this.count - end);
        }
        this.count -= end - start;
        return this;
    }

    public CPStringBuilder deleteCharAt(int index) {
        return this.delete(index, index + 1);
    }

    public CPStringBuilder replace(int start, int end, String str) {
        if (start < 0 || start > this.count || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int len = str.length();
        int delta = len - (end > this.count ? this.count : end) + start;
        this.ensureCapacity(this.count + delta);
        if (delta != 0 && end < this.count) {
            System.arraycopy(this.value, end, this.value, end + delta, this.count - end);
        }
        str.getChars(0, len, this.value, start);
        this.count += delta;
        return this;
    }

    public CPStringBuilder insert(int offset, char[] str, int str_offset, int len) {
        if (offset < 0 || offset > this.count || len < 0 || str_offset < 0 || str_offset > str.length - len) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, str_offset, this.value, offset, len);
        this.count += len;
        return this;
    }

    public CPStringBuilder insert(int offset, Object obj) {
        return this.insert(offset, obj == null ? "null" : obj.toString());
    }

    public CPStringBuilder insert(int offset, String str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (str == null) {
            str = "null";
        }
        int len = str.length();
        this.ensureCapacity(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count += len;
        return this;
    }

    public CPStringBuilder insert(int offset, CharSequence sequence) {
        if (sequence == null) {
            sequence = "null";
        }
        return this.insert(offset, sequence, 0, sequence.length());
    }

    public CPStringBuilder insert(int offset, CharSequence sequence, int start, int end) {
        if (sequence == null) {
            sequence = "null";
        }
        if (start < 0 || end < 0 || start > end || end > sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int len = end - start;
        this.ensureCapacity(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        int i = start;
        while (i < end) {
            this.value[offset++] = sequence.charAt(i);
            ++i;
        }
        this.count += len;
        return this;
    }

    public CPStringBuilder insert(int offset, char[] data) {
        return this.insert(offset, data, 0, data.length);
    }

    public CPStringBuilder insert(int offset, boolean bool) {
        return this.insert(offset, bool ? "true" : "false");
    }

    public CPStringBuilder insert(int offset, char ch) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = ch;
        ++this.count;
        return this;
    }

    public CPStringBuilder insert(int offset, int inum) {
        return this.insert(offset, String.valueOf(inum));
    }

    public CPStringBuilder insert(int offset, long lnum) {
        return this.insert(offset, Long.toString(lnum, 10));
    }

    public CPStringBuilder insert(int offset, float fnum) {
        return this.insert(offset, Float.toString(fnum));
    }

    public CPStringBuilder insert(int offset, double dnum) {
        return this.insert(offset, Double.toString(dnum));
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int olength = str.length();
        int limit = this.count - olength;
        String s = VMCPStringBuilder.toString(this.value, 0, this.count);
        while (fromIndex <= limit) {
            if (s.regionMatches(fromIndex, str, 0, olength)) {
                return fromIndex;
            }
            ++fromIndex;
        }
        return -1;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count - str.length());
    }

    public int lastIndexOf(String str, int fromIndex) {
        fromIndex = Math.min(fromIndex, this.count - str.length());
        String s = VMCPStringBuilder.toString(this.value, 0, this.count);
        int olength = str.length();
        while (fromIndex >= 0) {
            if (s.regionMatches(fromIndex, str, 0, olength)) {
                return fromIndex;
            }
            --fromIndex;
        }
        return -1;
    }

    public CPStringBuilder reverse() {
        this.ensureCapacity(this.count);
        int i = this.count >> 1;
        int j = this.count - i;
        while (--i >= 0) {
            char c = this.value[i];
            this.value[i] = this.value[j];
            this.value[j] = c;
            ++j;
        }
        return this;
    }

    public void trimToSize() {
        int wouldSave = this.value.length - this.count;
        if (wouldSave < 20) {
            return;
        }
        if (wouldSave > 200 || wouldSave * 4 > this.value.length) {
            this.allocateArray(this.count);
        }
    }

    public int codePointCount(int start, int end) {
        if (start < 0 || end >= this.count || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int count = 0;
        while (start < end) {
            char base = this.value[start];
            if (base >= '\ud800' && base <= '\udbff' && start != end && start != count && this.value[start + 1] >= '\udc00' && this.value[start + 1] <= '\udfff') {
                ++start;
            }
            ++start;
            ++count;
        }
        return count;
    }

    public int offsetByCodePoints(int start, int codePoints) {
        while (codePoints > 0) {
            char base = this.value[start];
            if (base >= '\ud800' && base <= '\udbff' && start != this.count && this.value[start + 1] >= '\udc00' && this.value[start + 1] <= '\udfff') {
                ++start;
            }
            ++start;
            --codePoints;
        }
        return start;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.allocated || minimumCapacity > this.value.length) {
            int max;
            minimumCapacity = minimumCapacity > this.value.length ? (minimumCapacity < (max = this.value.length * 2 + 2) ? max : minimumCapacity) : (minimumCapacity *= 2);
            this.allocateArray(minimumCapacity);
        }
    }

    private void allocateArray(int capacity) {
        char[] nb = new char[capacity];
        System.arraycopy(this.value, 0, nb, 0, this.count);
        this.value = nb;
        this.allocated = false;
    }

    public int length() {
        return this.count;
    }

    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public String substring(int beginIndex) {
        return this.substring(beginIndex, this.count);
    }

    public String substring(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.count || endIndex < beginIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = endIndex - beginIndex;
        if (len == 0) {
            return "";
        }
        this.allocated = true;
        return VMCPStringBuilder.toString(this.value, beginIndex, len);
    }

    public String toString() {
        this.allocated = true;
        return VMCPStringBuilder.toString(this.value, 0, this.count);
    }
}

