/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.Consumer;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomImpl;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class JAXPFactory
extends DocumentBuilderFactory {
    private static final String PROPERTY = "http://xml.org/sax/properties/";
    private static final String FEATURE = "http://xml.org/sax/features/";
    private SAXParserFactory pf;
    private boolean secureProcessing;

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        if (this.pf == null) {
            this.pf = new gnu.xml.aelfred2.JAXPFactory();
        }
        this.pf.setValidating(this.isValidating());
        this.pf.setNamespaceAware(this.isNamespaceAware());
        try {
            this.pf.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            return new JAXPBuilder(this.pf.newSAXParser().getXMLReader(), this);
        }
        catch (SAXException e) {
            String msg = "can't create JAXP DocumentBuilder: " + e.getMessage();
            throw new ParserConfigurationException(msg);
        }
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (!"http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(name)) {
            throw new IllegalArgumentException(name);
        }
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException(name);
    }

    public void setFeature(String name, boolean value) throws ParserConfigurationException {
        if (name == null) {
            throw new NullPointerException();
        }
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(name)) {
            this.secureProcessing = true;
            return;
        }
        throw new ParserConfigurationException(name);
    }

    public boolean getFeature(String name) throws ParserConfigurationException {
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(name)) {
            return this.secureProcessing;
        }
        throw new ParserConfigurationException(name);
    }

    static final class JAXPBuilder
    extends DocumentBuilder
    implements ErrorHandler {
        private Consumer consumer;
        private XMLReader producer;
        private DomImpl impl = new DomImpl();

        JAXPBuilder(XMLReader parser, JAXPFactory factory) throws ParserConfigurationException {
            try {
                this.consumer = new Consumer();
            }
            catch (SAXException e) {
                throw new ParserConfigurationException(e.getMessage());
            }
            this.consumer.setHidingReferences(factory.isExpandEntityReferences());
            this.consumer.setHidingComments(factory.isIgnoringComments());
            this.consumer.setHidingWhitespace(factory.isIgnoringElementContentWhitespace());
            this.consumer.setHidingCDATA(factory.isCoalescing());
            this.producer = parser;
            this.producer.setContentHandler(this.consumer.getContentHandler());
            this.producer.setDTDHandler(this.consumer.getDTDHandler());
            try {
                if (factory.isValidating()) {
                    this.producer.setFeature("http://xml.org/sax/features/validation", true);
                    this.producer.setErrorHandler(this);
                }
                this.producer.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                this.producer.setFeature("http://xml.org/sax/features/namespaces", factory.isNamespaceAware());
                String id = "http://xml.org/sax/properties/lexical-handler";
                this.producer.setProperty(id, this.consumer.getProperty(id));
                id = "http://xml.org/sax/properties/declaration-handler";
                this.producer.setProperty(id, this.consumer.getProperty(id));
            }
            catch (SAXException e) {
                throw new ParserConfigurationException(e.getMessage());
            }
        }

        public Document parse(InputSource source) throws SAXException, IOException {
            this.producer.parse(source);
            Document doc = this.consumer.getDocument();
            doc.setDocumentURI(source.getSystemId());
            return doc;
        }

        public boolean isNamespaceAware() {
            try {
                return this.producer.getFeature("http://xml.org/sax/features/namespaces");
            }
            catch (SAXException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        public boolean isValidating() {
            try {
                return this.producer.getFeature("http://xml.org/sax/features/validation");
            }
            catch (SAXException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        public void setEntityResolver(EntityResolver resolver) {
            this.producer.setEntityResolver(resolver);
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.producer.setErrorHandler(handler);
            this.consumer.setErrorHandler(handler);
        }

        public DOMImplementation getDOMImplementation() {
            return this.impl;
        }

        public Document newDocument() {
            return new DomDocument();
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
        }
    }
}

