/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AsyncBoxView;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ZoneView
extends BoxView {
    private int maximumZoneSize = 8192;
    private int maxZonesLoaded = 3;
    private LinkedList loadedZones = new LinkedList();

    public ZoneView(Element element, int axis) {
        super(element, axis);
    }

    public void setMaximumZoneSize(int size) {
        this.maximumZoneSize = size;
    }

    public int getMaximumZoneSize() {
        return this.maximumZoneSize;
    }

    public void setMaxZonesLoaded(int num) {
        if (num < 1) {
            throw new IllegalArgumentException("Illegal number of zones");
        }
        this.maxZonesLoaded = num;
        this.unloadOldestZones();
    }

    public int getMaxZonesLoaded() {
        return this.maxZonesLoaded;
    }

    protected void zoneWasLoaded(View zone) {
        this.loadedZones.addLast(zone);
        this.unloadOldestZones();
    }

    protected void unloadZone(View zone) {
        zone.removeAll();
    }

    protected boolean isZoneLoaded(View zone) {
        return zone.getViewCount() > 0;
    }

    protected View createZone(int p0, int p1) {
        Position pos1;
        Position pos0;
        block2: {
            Document doc = this.getDocument();
            pos0 = null;
            pos1 = null;
            try {
                pos0 = doc.createPosition(p0);
                pos1 = doc.createPosition(p1);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Must not happen");
            }
        }
        Zone zone = new Zone(this.getElement(), pos0, pos1, this.getAxis());
        return zone;
    }

    protected void loadChildren(ViewFactory vf) {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        this.append(this.createZone(p0, p1));
        this.checkZoneAt(p0);
    }

    protected int getViewIndexAtPosition(int pos) {
        int index = -1;
        boolean found = false;
        if (pos >= this.getStartOffset() && pos <= this.getEndOffset()) {
            int upper = this.getViewCount() - 1;
            int lower = 0;
            index = (upper - lower) / 2 + lower;
            int bias = 0;
            do {
                View child = this.getView(index);
                int childStart = child.getStartOffset();
                int childEnd = child.getEndOffset();
                if (pos >= childStart && pos < childEnd) {
                    found = true;
                } else if (pos < childStart) {
                    upper = index;
                    bias = -1;
                } else if (pos >= childEnd) {
                    lower = index;
                    bias = 1;
                }
                if (found) continue;
                int newIndex = (upper - lower) / 2 + lower;
                index = newIndex == index ? newIndex + bias : newIndex;
            } while (upper != lower && !found);
        }
        if (!found) {
            index = -1;
        }
        return index;
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory vf) {
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory vf) {
    }

    protected boolean updateChildren(DocumentEvent.ElementChange ec, DocumentEvent e, ViewFactory vf) {
        return false;
    }

    private void unloadOldestZones() {
        int maxZones = this.getMaxZonesLoaded();
        while (this.loadedZones.size() > maxZones) {
            View zone = (View)this.loadedZones.removeFirst();
            this.unloadZone(zone);
        }
    }

    private void checkZoneAt(int pos) {
        int viewIndex = this.getViewIndexAtPosition(pos);
        View view = this.getView(viewIndex);
        int p0 = view.getStartOffset();
        int p1 = view.getEndOffset();
        if (p1 - p0 > this.maximumZoneSize) {
            this.splitZone(viewIndex, p0, p1);
        }
    }

    private void splitZone(int index, int p0, int p1) {
        ArrayList<View> newZones = new ArrayList<View>();
        int p = p0;
        do {
            p0 = p;
            p = Math.min(this.getPreferredZoneEnd(p0), p1);
            newZones.add(this.createZone(p0, p));
        } while (p < p1);
        View[] newViews = new View[newZones.size()];
        newViews = newZones.toArray(newViews);
        this.replace(index, 1, newViews);
    }

    private int getPreferredZoneEnd(int start) {
        int p1;
        Element el = this.getElement();
        int index = el.getElementIndex(start + this.maximumZoneSize / 2);
        Element child = el.getElement(index);
        int p0 = child.getStartOffset();
        int end = p1 = child.getEndOffset();
        if (p0 - start > this.maximumZoneSize && p0 > start) {
            end = p0;
        }
        return end;
    }

    static class Zone
    extends AsyncBoxView {
        private Position p0;
        private Position p1;

        Zone(Element el, Position pos0, Position pos1, int axis) {
            super(el, axis);
            this.p0 = pos0;
            this.p1 = pos1;
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }
    }
}

