/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.common;

import gnu.javax.security.auth.callback.ConsoleCallbackHandler;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;

public abstract class CallbackUtil {
    private static final Logger log = Logger.getLogger(CallbackUtil.class.getName());

    public static final CallbackHandler getConsoleHandler() {
        CallbackHandler result = CallbackUtil.getHandler("Console");
        if (result == null) {
            log.fine("No console callback handler found. Will use ours");
            result = new ConsoleCallbackHandler();
        }
        return result;
    }

    private static final CallbackHandler getHandler(String handlerType) {
        log.entering(CallbackUtil.class.getName(), "getHandler", handlerType);
        CallbackHandler result = null;
        String service = "CallbackHandler." + handlerType;
        Provider[] providers = Security.getProviders(service);
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                Provider p = providers[i];
                String className = p.getProperty(service);
                if (className != null) {
                    try {
                        result = (CallbackHandler)Class.forName(className.trim()).newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        log.fine("InstantiationException while creating [" + className + "] from provider [" + p.getName() + "]. Ignore");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        log.fine("IllegalAccessException while creating [" + className + "] from provider [" + p.getName() + "]. Ignore");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        log.fine("ClassNotFoundException while creating [" + className + "] from provider [" + p.getName() + "]. Ignore");
                    }
                }
                if (result != null) {
                    log.fine("Will use [" + result.getClass().getName() + "] from [" + p.getName() + "]");
                    break;
                }
                ++i;
            }
        }
        log.exiting(CallbackUtil.class.getName(), "getHandler", result);
        return result;
    }
}

