/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html;

import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class CombinedAttributes
implements AttributeSet,
Serializable {
    final AttributeSet a;
    final AttributeSet b;

    public static AttributeSet combine(AttributeSet primary, AttributeSet secondary) {
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        return new CombinedAttributes(primary, secondary);
    }

    private CombinedAttributes(AttributeSet primary, AttributeSet secondary) {
        this.a = primary;
        this.b = secondary;
    }

    public boolean containsAttribute(Object name, Object value) {
        return this.a.containsAttribute(name, value) || this.b.containsAttribute(name, value);
    }

    public boolean containsAttributes(AttributeSet attributes) {
        Enumeration<?> names = attributes.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (this.containsAttribute(name, attributes.getAttribute(name))) continue;
            return false;
        }
        return true;
    }

    public AttributeSet copyAttributes() {
        SimpleAttributeSet copy = new SimpleAttributeSet();
        copy.addAttributes(this.a);
        copy.addAttributes(this.b);
        return copy;
    }

    public Object getAttribute(Object key) {
        Object value = this.a.getAttribute(key);
        if (value == null) {
            value = this.b.getAttribute(key);
        }
        return value;
    }

    public int getAttributeCount() {
        return this.a.getAttributeCount() + this.b.getAttributeCount();
    }

    public Enumeration getAttributeNames() {
        return new CombinedEnumeration(this.a.getAttributeNames(), this.b.getAttributeNames());
    }

    public AttributeSet getResolveParent() {
        return null;
    }

    public boolean isDefined(Object attrName) {
        return this.a.isDefined(attrName) || this.b.isDefined(attrName);
    }

    public boolean isEqual(AttributeSet attr) {
        if (attr.getAttributeCount() == this.getAttributeCount()) {
            return this.containsAttributes(attr);
        }
        return false;
    }

    class CombinedEnumeration
    implements Enumeration {
        final Enumeration a;
        final Enumeration b;

        CombinedEnumeration(Enumeration first, Enumeration second) {
            this.a = first;
            this.b = second;
        }

        public boolean hasMoreElements() {
            return this.a.hasMoreElements() || this.b.hasMoreElements();
        }

        public Object nextElement() {
            return this.a.hasMoreElements() ? this.a.nextElement() : this.b.nextElement();
        }
    }
}

