/*
 * Decompiled with CFR 0.152.
 */
package sarif;

import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.MultiformatMessageString;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import com.contrastsecurity.sarif.State;
import docking.widgets.table.ObjectSelectedListener;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.EmptyGraphType;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphType;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.GraphException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sarif.SarifGraphDisplayListener;
import sarif.SarifPlugin;
import sarif.SarifUtils;
import sarif.handlers.SarifResultHandler;
import sarif.handlers.SarifRunHandler;
import sarif.handlers.run.SarifGraphRunHandler;
import sarif.managers.ProgramSarifMgr;
import sarif.model.SarifDataFrame;
import sarif.view.ImageArtifactDisplay;
import sarif.view.SarifResultsTableProvider;

public class SarifController
implements ObjectSelectedListener<Map<String, Object>> {
    private SarifPlugin plugin;
    private Program program;
    private ColorizingService coloringService;
    private BookmarkManager bookmarkManager;
    private ProgramSarifMgr programManager;
    private Set<SarifResultsTableProvider> providers = new HashSet<SarifResultsTableProvider>();
    public Set<ImageArtifactDisplay> artifacts = new HashSet<ImageArtifactDisplay>();
    public Set<GraphDisplay> graphs = new HashSet<GraphDisplay>();
    private Class<? extends SarifGraphRunHandler> defaultGraphHandler = SarifGraphRunHandler.class;
    private boolean useOverlays;

    public Set<SarifResultHandler> getSarifResultHandlers() {
        HashSet<SarifResultHandler> set = new HashSet<SarifResultHandler>();
        set.addAll(ClassSearcher.getInstances(SarifResultHandler.class));
        return set;
    }

    public Set<SarifRunHandler> getSarifRunHandlers() {
        HashSet<SarifRunHandler> set = new HashSet<SarifRunHandler>();
        set.addAll(ClassSearcher.getInstances(SarifRunHandler.class));
        return set;
    }

    public SarifController(Program program, SarifPlugin plugin) {
        this.program = program;
        this.plugin = plugin;
        this.coloringService = (ColorizingService)plugin.getTool().getService(ColorizingService.class);
        this.programManager = new ProgramSarifMgr(program, new MessageLog());
    }

    public SarifController(ProgramSarifMgr manager) {
        this.program = null;
        this.plugin = null;
        this.coloringService = null;
        this.programManager = manager;
    }

    public void dispose() {
        HashSet<SarifResultsTableProvider> copyProviders = new HashSet<SarifResultsTableProvider>();
        copyProviders.addAll(this.providers);
        for (SarifResultsTableProvider p : copyProviders) {
            p.dispose();
        }
        HashSet<ImageArtifactDisplay> copyArtifacts = new HashSet<ImageArtifactDisplay>();
        copyArtifacts.addAll(this.artifacts);
        for (ImageArtifactDisplay a : copyArtifacts) {
            a.dispose();
        }
        for (GraphDisplay g : this.graphs) {
            g.close();
        }
    }

    public void showTable(boolean makeVisible) {
        for (SarifResultsTableProvider p : this.providers) {
            p.setVisible(makeVisible);
        }
    }

    public void showTable(String logName, SarifSchema210 sarif) {
        SarifDataFrame df = new SarifDataFrame(sarif, this, false);
        int size = df.getTableResults().size();
        if (size != 0) {
            logName = (String)logName + "  [" + size + "]";
        }
        SarifResultsTableProvider provider = new SarifResultsTableProvider((String)logName, (Plugin)this.getPlugin(), this, df);
        provider.filterTable.addSelectionListener((ObjectSelectedListener)this);
        provider.addToTool();
        provider.setVisible(true);
        provider.setTitle((String)logName);
        if (!this.providers.contains((Object)provider)) {
            this.providers.add(provider);
        }
    }

    public void showImage(String key, BufferedImage img) {
        if (this.getPlugin().displayArtifacts()) {
            ImageArtifactDisplay display = new ImageArtifactDisplay(this.getPlugin().getTool(), key, "Sarif Parse", img);
            display.setVisible(true);
            this.artifacts.add(display);
        }
    }

    public void showGraph(AttributedGraph graph) {
        try {
            PluginTool tool = this.getPlugin().getTool();
            GraphDisplayBroker service = (GraphDisplayBroker)tool.getService(GraphDisplayBroker.class);
            boolean append = this.getPlugin().appendToGraph();
            GraphDisplay display = service.getDefaultGraphDisplay(append, null);
            GraphDisplayOptions graphOptions = new GraphDisplayOptions((GraphType)new EmptyGraphType());
            graphOptions.setMaxNodeCount(this.getPlugin().getGraphSize());
            if (this.getPlugin().displayGraphs()) {
                display.setGraph(graph, graphOptions, graph.getDescription(), append, null);
                SarifGraphDisplayListener listener = new SarifGraphDisplayListener(this, display, graph);
                display.setGraphDisplayListener((GraphDisplayListener)listener);
                this.graphs.add(display);
            }
        }
        catch (CancelledException | GraphException e) {
            Msg.error((Object)this, (Object)("showGraph failed " + e.getMessage()));
        }
    }

    public void handleListingAction(Run run, Result result, String key, Object value) {
        List<Address> addrs = this.getListingAddresses(run, result);
        for (Address addr : addrs) {
            switch (key) {
                case "comment": {
                    String comment = (String)value;
                    this.getProgram().getListing().setComment(addr, CommentType.PLATE, comment);
                    break;
                }
                case "highlight": {
                    Color color = Color.decode((String)value);
                    this.coloringService.setBackgroundColor(addr, addr, color);
                    break;
                }
                case "bookmark": {
                    String bookmark = (String)value;
                    this.getProgram().getBookmarkManager().setBookmark(addr, "Sarif", result.getRuleId(), bookmark);
                }
            }
        }
    }

    public void colorBackground(AddressSetView set, Color color) {
        this.coloringService.setBackgroundColor(set, color);
    }

    public void colorBackground(Address addr, Color color) {
        this.coloringService.setBackgroundColor(addr, addr, color);
    }

    public List<Address> getListingAddresses(Run run, Result result) {
        ArrayList<Address> addrs = new ArrayList<Address>();
        if (result.getLocations() != null && result.getLocations().size() > 0) {
            List locations = result.getLocations();
            for (Location loc : locations) {
                Address addr = this.locationToAddress(run, loc);
                if (addr == null) continue;
                addrs.add(addr);
            }
        }
        return addrs;
    }

    public Address locationToAddress(Run run, Location loc) {
        return SarifUtils.locationToAddress(loc, this.program, this.useOverlays);
    }

    public String getStateText(State state, String stateKey) {
        String result = "";
        Map state_mappings = state.getAdditionalProperties();
        for (Map.Entry pair : state_mappings.entrySet()) {
            if (!((String)pair.getKey()).equalsIgnoreCase(stateKey)) continue;
            result = ((MultiformatMessageString)pair.getValue()).getText();
            break;
        }
        return result;
    }

    public void objectSelected(Map<String, Object> row) {
        if (row != null) {
            if (row.containsKey("CodeFlows")) {
                for (List flow : (List)row.get("CodeFlows")) {
                    this.getPlugin().makeSelection(flow);
                }
            }
            if (row.containsKey("Graphs")) {
                for (AttributedGraph graph : (List)row.get("Graphs")) {
                    this.showGraph(graph);
                }
            }
        }
    }

    public void removeProvider(SarifResultsTableProvider provider) {
        this.providers.remove((Object)provider);
    }

    public ProgramSarifMgr getProgramSarifMgr() {
        return this.programManager;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
        this.bookmarkManager = program.getBookmarkManager();
        this.bookmarkManager.defineType("Sarif", SarifPlugin.SARIF_ICON, Color.pink, 0);
    }

    public SarifPlugin getPlugin() {
        return this.plugin;
    }

    public void setSelection(Set<AttributedVertex> vertices) {
        for (SarifResultsTableProvider provider : this.providers) {
            provider.setSelection(vertices);
        }
    }

    public Class<? extends SarifGraphRunHandler> getDefaultGraphHander() {
        return this.defaultGraphHandler;
    }

    public void setDefaultGraphHander(Class<? extends SarifGraphRunHandler> clazz) {
        this.defaultGraphHandler = clazz;
    }

    public void setUseOverlays(boolean useOverlays) {
        this.useOverlays = useOverlays;
    }
}

