/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.ConstantValueSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.expression.UnaryExpression;
import java.util.Map;
import java.util.Set;

public abstract class AbstractUnaryExpressionSolver<T extends UnaryExpression>
extends AbstractExpressionSolver<T> {
    public AbstractUnaryExpressionSolver(Class<T> tcls) {
        super(tcls);
    }

    @Override
    public AssemblyResolution solve(AbstractAssemblyResolutionFactory<?, ?> factory, T exp, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException {
        MaskedLong cval;
        MaskedLong uval = this.solver.getValue(((UnaryExpression)exp).getUnary(), vals, cur);
        if (uval != null && uval.isFullyDefined() && (cval = this.compute(uval)) != null) {
            return ConstantValueSolver.checkConstAgrees(factory, cval, goal, description);
        }
        return this.solver.solve(factory, ((UnaryExpression)exp).getUnary(), this.computeInverse(goal), vals, cur, hints, description);
    }

    @Override
    public MaskedLong getValue(T exp, Map<String, Long> vals, AssemblyResolvedPatterns cur) throws NeedsBackfillException {
        MaskedLong val = this.solver.getValue(((UnaryExpression)exp).getUnary(), vals, cur);
        if (val != null) {
            return this.compute(val);
        }
        return null;
    }

    public MaskedLong computeInverse(MaskedLong goal) {
        return this.compute(goal);
    }

    public abstract MaskedLong compute(MaskedLong var1);

    @Override
    public int getInstructionLength(T exp) {
        return this.solver.getInstructionLength(((UnaryExpression)exp).getUnary());
    }

    @Override
    public MaskedLong valueForResolution(T exp, Map<String, Long> vals, AssemblyResolvedPatterns rc) {
        MaskedLong val = this.solver.valueForResolution(((UnaryExpression)exp).getUnary(), vals, rc);
        return this.compute(val);
    }
}

