/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.symbol.LibraryDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Library;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramEvent;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class LibrarySymbol
extends SymbolDB {
    private LibraryDB library;

    public LibrarySymbol(SymbolManager symbolMgr, DBObjectCache<SymbolDB> cache, DBRecord record) {
        super(symbolMgr, cache, Address.NO_ADDRESS, record);
    }

    @Override
    public void setName(String newName, SourceType source) throws DuplicateNameException, InvalidInputException {
        String oldName = this.getName();
        if ("<EXTERNAL>".equals(oldName)) {
            Msg.warn((Object)this, (Object)"Unable to change name of <EXTERNAL> Library");
            return;
        }
        super.setName(newName, source);
        if (!oldName.equals(this.getName())) {
            this.symbolMgr.getProgram().setObjChanged(ProgramEvent.EXTERNAL_NAME_CHANGED, null, null, oldName, newName);
        }
    }

    @Override
    public void setNameAndNamespace(String newName, Namespace newNamespace, SourceType source) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        String oldName = this.getName();
        super.setNameAndNamespace(newName, newNamespace, source);
        if (!oldName.equals(this.getName())) {
            this.symbolMgr.getProgram().setObjChanged(ProgramEvent.EXTERNAL_NAME_CHANGED, null, null, oldName, newName);
        }
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.LIBRARY;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public Library getObject() {
        this.lock.acquire();
        try {
            if (!this.checkIsValid()) {
                Library library = null;
                return library;
            }
            if (this.library == null) {
                this.library = new LibraryDB(this, this.symbolMgr.getProgram().getNamespaceManager());
            }
            LibraryDB libraryDB = this.library;
            return libraryDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return super.isValidParent(parent) && SymbolType.LIBRARY.isValidParent(this.symbolMgr.getProgram(), parent, this.address, this.isExternal());
    }

    public String getExternalLibraryPath() {
        this.validate(this.lock);
        return this.record.getString(12);
    }

    public void setExternalLibraryPath(String libraryPath) {
        String oldPath = this.getExternalLibraryPath();
        this.lock.acquire();
        try {
            this.checkDeleted();
            LibrarySymbol.setRecordFields(this.record, libraryPath);
            this.updateRecord();
        }
        finally {
            this.lock.release();
        }
        this.symbolMgr.getProgram().setObjChanged(ProgramEvent.EXTERNAL_PATH_CHANGED, this.getName(), oldPath, libraryPath);
    }

    static void setRecordFields(DBRecord record, String libraryPath) {
        record.setString(12, libraryPath);
    }
}

