/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;

public class InjectContext {
    public SleighLanguage language;
    public Address baseAddr;
    public Address nextAddr;
    public Address callAddr;
    public Address refAddr;
    public ArrayList<Varnode> inputlist;
    public ArrayList<Varnode> output;

    public void decode(Decoder decoder) throws DecoderException {
        int size;
        Address addr;
        int addrel;
        int el = decoder.openElement(ElementId.ELEM_CONTEXT);
        this.baseAddr = AddressXML.decode(decoder);
        this.callAddr = AddressXML.decode(decoder);
        int subel = decoder.peekElement();
        if (subel == ElementId.ELEM_INPUT.id()) {
            decoder.openElement();
            this.inputlist = new ArrayList();
            while ((addrel = decoder.peekElement()) != 0) {
                decoder.openElement();
                addr = AddressXML.decodeFromAttributes(decoder);
                size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
                decoder.closeElement(addrel);
                this.inputlist.add(new Varnode(addr, size));
            }
            decoder.closeElement(subel);
            subel = decoder.peekElement();
        }
        if (subel == ElementId.ELEM_OUTPUT.id()) {
            decoder.openElement();
            this.output = new ArrayList();
            while ((addrel = decoder.peekElement()) != 0) {
                decoder.openElement();
                addr = AddressXML.decodeFromAttributes(decoder);
                size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
                decoder.closeElement(addrel);
                this.output.add(new Varnode(addr, size));
            }
            decoder.closeElement(subel);
        }
        decoder.closeElement(el);
    }
}

