/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.EmptyAddressRangeIterator;
import ghidra.util.AbstractAddressSetView;
import ghidra.util.AddressRangeIterators;
import ghidra.util.MathUtilities;

public class IntersectionAddressSetView
extends AbstractAddressSetView {
    private final AddressSetView a;
    private final AddressSetView b;

    public IntersectionAddressSetView(AddressSetView a, AddressSetView b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public boolean contains(Address addr) {
        return this.a.contains(addr) && this.b.contains(addr);
    }

    @Override
    public boolean contains(Address start, Address end) {
        return this.a.contains(start, end) && this.b.contains(start, end);
    }

    @Override
    public boolean contains(AddressSetView rangeSet) {
        return this.a.contains(rangeSet) && this.b.contains(rangeSet);
    }

    protected Address findStart(boolean forward) {
        Address bStart;
        if (forward) {
            Address bStart2;
            Address aStart = this.a.getMinAddress();
            if (aStart == null || (bStart2 = this.b.getMinAddress()) == null) {
                return null;
            }
            return (Address)MathUtilities.cmax((Comparable)aStart, (Comparable)bStart2);
        }
        Address aStart = this.a.getMaxAddress();
        if (aStart == null || (bStart = this.b.getMaxAddress()) == null) {
            return null;
        }
        return (Address)MathUtilities.cmin((Comparable)aStart, (Comparable)bStart);
    }

    protected Address adjustStart(Address start, boolean forward) {
        if (forward) {
            AddressRangeIterator it = this.a.getAddressRanges(start, forward);
            if (!it.hasNext()) {
                return null;
            }
            Address aStart = ((AddressRange)it.next()).getMinAddress();
            it = this.b.getAddressRanges(start, forward);
            if (!it.hasNext()) {
                return null;
            }
            Address bStart = ((AddressRange)it.next()).getMinAddress();
            return (Address)MathUtilities.cmax((Comparable)aStart, (Comparable)bStart);
        }
        AddressRangeIterator it = this.a.getAddressRanges(start, forward);
        if (!it.hasNext()) {
            return null;
        }
        Address aStart = ((AddressRange)it.next()).getMaxAddress();
        it = this.b.getAddressRanges(start, forward);
        if (!it.hasNext()) {
            return null;
        }
        Address bStart = ((AddressRange)it.next()).getMaxAddress();
        return (Address)MathUtilities.cmin((Comparable)aStart, (Comparable)bStart);
    }

    @Override
    public AddressRangeIterator getAddressRanges() {
        return this.getAddressRanges(true);
    }

    protected AddressRangeIterator doGetRanges(Address start, boolean forward) {
        if (start == null) {
            return new EmptyAddressRangeIterator();
        }
        return AddressRangeIterators.intersect(this.a.iterator(start, forward), this.b.iterator(start, forward), forward);
    }

    @Override
    public AddressRangeIterator getAddressRanges(boolean forward) {
        return this.doGetRanges(this.findStart(forward), forward);
    }

    @Override
    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return this.doGetRanges(this.adjustStart(start, forward), forward);
    }

    @Override
    public AddressRange getRangeContaining(Address address) {
        AddressRange ar = this.a.getRangeContaining(address);
        if (ar == null) {
            return null;
        }
        AddressRange br = this.b.getRangeContaining(address);
        if (br == null) {
            return null;
        }
        return ar.intersect(br);
    }
}

