/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.model.Point;

public interface LayoutVertexPositionChange {

    public static interface Listener<V> {
        public void layoutVertexPositionChanged(Event<V> var1);

        public void layoutVertexPositionChanged(GraphEvent<V> var1);
    }

    public static class GraphEvent<V>
    extends Event<V> {
        final Graph<V, ?> graph;

        public GraphEvent(V vertex, Graph<V, ?> graph, Point location) {
            super(vertex, location);
            this.graph = graph;
        }

        public GraphEvent(Event<V> layoutEvent, Graph<V, ?> graph) {
            super(layoutEvent.vertex, layoutEvent.location);
            this.graph = graph;
        }

        public Graph<V, ?> getGraph() {
            return this.graph;
        }
    }

    public static class Event<V> {
        public final V vertex;
        public final Point location;

        public Event(V vertex, Point location) {
            this.vertex = vertex;
            this.location = location;
        }
    }

    public static class SupportImpl<V>
    implements Support<V> {
        protected boolean fireEvents = true;
        protected List<Listener<V>> changeListeners = Collections.synchronizedList(new ArrayList());

        private SupportImpl() {
        }

        @Override
        public boolean isFireEvents() {
            return this.fireEvents;
        }

        @Override
        public void setFireEvents(boolean fireEvents) {
            this.fireEvents = fireEvents;
        }

        @Override
        public void addLayoutVertexPositionChangeListener(Listener l) {
            this.changeListeners.add(l);
        }

        @Override
        public void removeLayoutVertexPositionChangeListener(Listener l) {
            this.changeListeners.remove(l);
        }

        @Override
        public List<Listener<V>> getLayoutVertexPositionChangeListeners() {
            return this.changeListeners;
        }

        @Override
        public void fireLayoutVertexPositionChanged(V vertex, Point location) {
            if (this.fireEvents && this.changeListeners.size() > 0) {
                Event<V> layoutEvent = new Event<V>(vertex, location);
                for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                    this.changeListeners.get(i).layoutVertexPositionChanged(layoutEvent);
                }
            }
        }
    }

    public static interface Support<V> {
        public static Support create() {
            return new SupportImpl();
        }

        public boolean isFireEvents();

        public void setFireEvents(boolean var1);

        public void addLayoutVertexPositionChangeListener(Listener<V> var1);

        public void removeLayoutVertexPositionChangeListener(Listener<V> var1);

        public List<Listener<V>> getLayoutVertexPositionChangeListeners();

        public void fireLayoutVertexPositionChanged(V var1, Point var2);
    }

    public static interface Producer<V> {
        public Support<V> getLayoutVertexPositionSupport();
    }
}

