/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.MachoExtractProgramBuilder;
import ghidra.app.util.opinion.MachoLoader;
import ghidra.file.formats.ios.fileset.MachoFileSetExtractor;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MachoFileSetExtractLoader
extends MachoLoader {
    public static final String MACHO_FILESET_EXTRACT_NAME = "Extracted Mach-O File Set Entry";

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        if (provider.length() >= (long)MachoFileSetExtractor.FOOTER_V1.length && Arrays.equals(MachoFileSetExtractor.FOOTER_V1, provider.readBytes(provider.length() - (long)MachoFileSetExtractor.FOOTER_V1.length, (long)MachoFileSetExtractor.FOOTER_V1.length))) {
            return super.findSupportedLoadSpecs(provider);
        }
        return List.of();
    }

    public void load(Program program, Loader.ImporterSettings settings) throws IOException {
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes((Program)program, (ByteProvider)settings.provider(), (TaskMonitor)settings.monitor());
            MachoExtractProgramBuilder.buildProgram(program, settings.provider(), fileBytes, false, settings.log(), settings.monitor());
        }
        catch (CancelledException e) {
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void loadProgramInto(Program program, Loader.ImporterSettings settings) throws IOException, LoadException, CancelledException {
        FSRL fsrl = settings.provider().getFSRL();
        Group[] children = program.getListing().getDefaultRootModule().getChildren();
        if (Arrays.stream(children).anyMatch(e -> e.getName().contains(fsrl.getPath()))) {
            settings.log().appendMsg("%s has already been added".formatted(fsrl.getPath()));
            return;
        }
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes((Program)program, (ByteProvider)settings.provider(), (TaskMonitor)settings.monitor());
            MachoExtractProgramBuilder.buildProgram(program, settings.provider(), fileBytes, true, settings.log(), settings.monitor());
        }
        catch (CancelledException e2) {
            return;
        }
        catch (IOException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new IOException(e4);
        }
    }

    public boolean supportsLoadIntoProgram(Program program) {
        return MACHO_FILESET_EXTRACT_NAME.equals(program.getExecutableFormat());
    }

    public String getName() {
        return MACHO_FILESET_EXTRACT_NAME;
    }

    public int getTierPriority() {
        return 49;
    }

    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram, boolean mirrorFsLayout) {
        return List.of();
    }

    protected boolean isLoadLibraries(Loader.ImporterSettings settings) {
        return false;
    }

    protected boolean shouldSearchAllPaths(Program program, Loader.ImporterSettings settings) {
        return false;
    }

    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Loader.ImporterSettings settings) throws CancelledException, IOException {
    }
}

