/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.Date;

public class SquashSuperBlock {
    private final int magic;
    private final int inodeCount;
    private final long modTime;
    private final int blockSize;
    private final long totalFragments;
    private final int compressionType;
    private final int blockLog;
    private final int flags;
    private final int totalIDs;
    private final int majorVersion;
    private final int minorVersion;
    private final long rootInode;
    private final long bytesUsed;
    private final long idTableStart;
    private final long xattrIdTableStart;
    private final long inodeTableStart;
    private final long directoryTableStart;
    private final long fragmentTableStart;
    private final long exportTableStart;

    SquashSuperBlock(BinaryReader reader) throws IOException {
        this.magic = reader.readNextInt();
        this.inodeCount = reader.readNextUnsignedIntExact();
        this.modTime = reader.readNextUnsignedInt();
        this.blockSize = reader.readNextUnsignedIntExact();
        this.totalFragments = reader.readNextUnsignedInt();
        this.compressionType = reader.readNextUnsignedShort();
        this.blockLog = reader.readNextUnsignedShort();
        this.flags = reader.readNextUnsignedShort();
        this.totalIDs = reader.readNextUnsignedShort();
        this.majorVersion = reader.readNextUnsignedShort();
        this.minorVersion = reader.readNextUnsignedShort();
        this.rootInode = reader.readNextLong();
        this.bytesUsed = reader.readNextLong();
        this.idTableStart = reader.readNextLong();
        this.xattrIdTableStart = reader.readNextLong();
        this.inodeTableStart = reader.readNextLong();
        this.directoryTableStart = reader.readNextLong();
        this.fragmentTableStart = reader.readNextLong();
        this.exportTableStart = reader.readNextLong();
        this.checkCompatibility();
    }

    public int getMagic() {
        return this.magic;
    }

    public int getInodeCount() {
        return this.inodeCount;
    }

    public long getModTime() {
        return this.modTime;
    }

    public Date getModTimeAsDate() {
        return new Date(this.modTime * 1000L);
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public long getTotalFragments() {
        return this.totalFragments;
    }

    public int getCompressionType() {
        return this.compressionType;
    }

    public int getBlockLog() {
        return this.blockLog;
    }

    public int getRawFlags() {
        return this.flags;
    }

    public int getTotalIDs() {
        return this.totalIDs;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public long getRootInode() {
        return this.rootInode;
    }

    public long getRootInodeBlockLocation() {
        return this.rootInode >> 16;
    }

    public long getRootInodeOffset() {
        return this.rootInode & 0xFFFFL;
    }

    public long getBytesUsed() {
        return this.bytesUsed;
    }

    public long getIdTableStart() {
        return this.idTableStart;
    }

    public long getXattrIdTableStart() {
        return this.xattrIdTableStart;
    }

    public long getInodeTableStart() {
        return this.inodeTableStart;
    }

    public long getDirectoryTableStart() {
        return this.directoryTableStart;
    }

    public long getFragmentTableStart() {
        return this.fragmentTableStart;
    }

    public long getExportTableStart() {
        return this.exportTableStart;
    }

    public boolean isInodesUncompressed() {
        return (this.flags & 1) != 0;
    }

    public boolean isDataUncompressed() {
        return (this.flags & 2) != 0;
    }

    public boolean isUsedFlagSet() {
        return (this.flags & 4) != 0;
    }

    public boolean isFragmentsUncompressed() {
        return (this.flags & 8) != 0;
    }

    public boolean isFragmentsUnused() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isAlwaysFragment() {
        return (this.flags & 0x20) != 0;
    }

    public boolean allowDuplicates() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isExportable() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isXattrsUncompressed() {
        return (this.flags & 0x100) != 0;
    }

    public boolean hasXattrs() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isCompressionOptionsPresent() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isIDsUncompressed() {
        return (this.flags & 0x800) != 0;
    }

    public String getVersionString() {
        return this.majorVersion + "." + this.minorVersion;
    }

    public void checkCompatibility() {
        if (this.majorVersion != 4 || this.minorVersion != 0) {
            Msg.warn((Object)this, (Object)("SquashFS archive is version " + this.majorVersion + "." + this.minorVersion + " but Ghidra has only been tested with version 4.0"));
        }
        if (this.xattrIdTableStart == -1L) {
            Msg.info((Object)this, (Object)"In SquashFS archive, the optional Xattr table is missing");
        }
        if (this.fragmentTableStart == -1L) {
            Msg.info((Object)this, (Object)"In SquashFS archive, the optional fragment table is missing");
        }
        if (this.exportTableStart == -1L) {
            Msg.info((Object)this, (Object)"In SquashFS archive, the optional export table is missing");
        }
        if (this.isUsedFlagSet() && this.majorVersion >= 4) {
            Msg.warn((Object)this, (Object)"In SquashFS archive super block, the unused flag is set when it should be cleared. Per standard, the archive is invalid. Continue with caution!");
        }
        if (1 << this.blockLog != this.blockSize) {
            Msg.warn((Object)this, (Object)"In SquashFS archive super block, the blocksize does not match the blockLog value. Per standard, the archive is invalid. Continue with caution!");
        }
        if (this.isInodesUncompressed() != this.isIDsUncompressed() && this.majorVersion >= 4) {
            Msg.warn((Object)this, (Object)"In SquashFS archive super block, the flags for whether inodes and IDsare compressed should match. This is to maintain backwards compantability, but they differ in your archive. Continue with caution!");
        }
    }

    public String getCompressionTypeString() {
        switch (this.compressionType) {
            case 1: {
                return "gzip";
            }
            case 2: {
                return "lzma";
            }
            case 3: {
                return "lzo";
            }
            case 4: {
                return "xz";
            }
            case 5: {
                return "lz4-block";
            }
            case 6: {
                return "zstd";
            }
        }
        return "Unknown";
    }
}

