/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.jad;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.file.jad.JadProcessWrapper;
import ghidra.file.jad.JarDecompiler;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.File;
import java.util.List;

public class JadFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;
    private File lastDirectory;

    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder("FSB Decompile JAR", this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && JadProcessWrapper.isJadPresent() && ac.getFileFSRL() != null).popupMenuPath(new String[]{"Decompile JAR"}).popupMenuIcon(FSBIcons.JAR).popupMenuGroup("J").onAction(ac -> {
            FSRL jarFSRL = ac.getFileFSRL();
            if (jarFSRL == null) {
                return;
            }
            this.lastDirectory = this.lastDirectory == null ? new File(System.getProperty("user.home")) : this.lastDirectory;
            GhidraFileChooser chooser = new GhidraFileChooser((Component)ac.getSourceComponent());
            chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
            chooser.setTitle("Select JAR Output Directory");
            chooser.setApproveButtonText("SELECT");
            chooser.setCurrentDirectory(this.context.plugin().getLastExportDirectory());
            File selectedFile = chooser.getSelectedFile();
            chooser.dispose();
            if (selectedFile == null) {
                return;
            }
            this.lastDirectory = selectedFile;
            this.context.fsbComponent().runTask(monitor -> {
                try {
                    JarDecompiler decompiler = new JarDecompiler(jarFSRL, selectedFile);
                    decompiler.decompile(monitor);
                    if (decompiler.getLog().hasMessages()) {
                        Msg.showInfo((Object)this, null, (String)("Decompiling Jar " + jarFSRL.getName()), (Object)decompiler.getLog().toString());
                    }
                }
                catch (Exception e) {
                    FSUtilities.displayException((Object)this, null, (String)"Error Decompiling Jar", (String)e.getMessage(), (Throwable)e);
                }
            });
        }).build());
    }
}

