/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api;

import generic.lsh.vector.LSHVector;
import ghidra.feature.vt.api.FunctionPair;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FunctionNode
implements Comparable<FunctionNode> {
    private final Address addr;
    private final String name;
    private final LSHVector vec;
    private ArrayList<Address> callAddresses;
    private final Set<FunctionNode> children;
    private final Set<FunctionNode> parents;
    private Map<FunctionNode, FunctionPair> associates;
    private final int len;
    private boolean acceptedMatch;

    public static Set<FunctionNode> neigborhoodAllocate() {
        return new HashSet<FunctionNode>();
    }

    public FunctionNode(Function function, LSHVector vector, ArrayList<Address> callAddresses) {
        this.addr = function.getEntryPoint();
        this.name = function.getName();
        this.vec = vector;
        this.callAddresses = callAddresses;
        this.associates = new HashMap<FunctionNode, FunctionPair>();
        this.children = FunctionNode.neigborhoodAllocate();
        this.parents = FunctionNode.neigborhoodAllocate();
        int val = (int)function.getBody().getNumAddresses();
        this.len = val == 0 ? 1 : val;
        this.acceptedMatch = false;
    }

    public int hashCode() {
        return this.addr == null ? 0 : this.addr.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionNode other = (FunctionNode)obj;
        return !(this.addr == null ? other.addr != null : !this.addr.equals((Object)other.addr));
    }

    @Override
    public int compareTo(FunctionNode other) {
        return this.addr.compareTo((Object)other.addr);
    }

    public String toString() {
        return this.name;
    }

    public Address getAddress() {
        return this.addr;
    }

    public LSHVector getVector() {
        return this.vec;
    }

    public List<Address> releaseCallAddresses() {
        ArrayList<Address> res = this.callAddresses;
        this.callAddresses = null;
        return res;
    }

    public Set<FunctionNode> getChildren() {
        return this.children;
    }

    public Set<FunctionNode> getParents() {
        return this.parents;
    }

    public void addAssociate(FunctionNode other, FunctionPair pair) {
        this.associates.put(other, pair);
    }

    public void removeAssociate(FunctionNode other) {
        this.associates.remove(other);
    }

    public void clearAssociates() {
        this.associates.clear();
    }

    public Iterator<Map.Entry<FunctionNode, FunctionPair>> getAssociateIterator() {
        return this.associates.entrySet().iterator();
    }

    public FunctionPair findEdge(FunctionNode other) {
        return this.associates.get(other);
    }

    public int getLen() {
        return this.len;
    }

    public boolean isAcceptedMatch() {
        return this.acceptedMatch;
    }

    public void setAcceptedMatch(boolean used) {
        this.acceptedMatch = used;
    }
}

