/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.feature.vt.api.FunctionNode;
import ghidra.feature.vt.api.FunctionNodeContainer;
import ghidra.feature.vt.api.NeighborGenerator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import java.util.Set;
import java.util.TreeMap;

public class NamespaceNeighborhood
extends NeighborGenerator {
    private FunctionNodeContainer sourceNodes;
    private FunctionNodeContainer destNodes;
    private TreeMap<Long, Set<FunctionNode>> sourceSets;
    private TreeMap<Long, Set<FunctionNode>> destSets;
    private TreeMap<PairLabel, NeighborGenerator.NeighborhoodPair> namespacePair;
    private PairLabel cacheKey;

    public NamespaceNeighborhood(LSHVectorFactory vectorFactory, double impThreshold, FunctionNodeContainer sourceNodes, FunctionNodeContainer destNodes) {
        super(vectorFactory, impThreshold);
        this.sourceNodes = sourceNodes;
        this.destNodes = destNodes;
        this.sourceSets = new TreeMap();
        this.destSets = new TreeMap();
        this.namespacePair = new TreeMap();
        this.cacheKey = new PairLabel();
    }

    private Namespace getNamespace(FunctionNode root, FunctionNodeContainer container) {
        Function function = container.getProgram().getFunctionManager().getFunctionAt(root.getAddress());
        if (function == null) {
            return null;
        }
        Namespace namespace = function.getParentNamespace();
        return namespace;
    }

    private Set<FunctionNode> buildNeighborhood(Namespace namespace, Long namespaceKey, FunctionNodeContainer container, TreeMap<Long, Set<FunctionNode>> sets) {
        Set<FunctionNode> resultSet = sets.get(namespaceKey);
        if (resultSet == null) {
            resultSet = FunctionNode.neigborhoodAllocate();
            SymbolTable symbolTable = container.getProgram().getSymbolTable();
            SymbolIterator iter = symbolTable.getSymbols(namespace);
            while (iter.hasNext()) {
                FunctionNode node;
                Symbol sym = iter.next();
                if (sym.getSymbolType() != SymbolType.FUNCTION || (node = container.get(sym.getAddress())) == null) continue;
                resultSet.add(node);
            }
            sets.put(namespaceKey, resultSet);
        }
        return resultSet;
    }

    private NeighborGenerator.NeighborhoodPair findPair(Long srcKey, Long destKey) {
        this.cacheKey.srcLabel = srcKey;
        this.cacheKey.destLabel = destKey;
        return this.namespacePair.get(this.cacheKey);
    }

    private void cachePair(Long srcKey, Long destKey, NeighborGenerator.NeighborhoodPair pair) {
        PairLabel newLabel = new PairLabel();
        newLabel.srcLabel = srcKey;
        newLabel.destLabel = destKey;
        this.namespacePair.put(newLabel, pair);
    }

    @Override
    public NeighborGenerator.NeighborhoodPair generate(FunctionNode srcRoot, FunctionNode destRoot) {
        Long destNamespaceKey;
        Namespace srcNamespace = this.getNamespace(srcRoot, this.sourceNodes);
        Namespace destNamespace = this.getNamespace(destRoot, this.destNodes);
        if (srcNamespace == null || destNamespace == null) {
            NeighborGenerator.NeighborhoodPair pair = new NeighborGenerator.NeighborhoodPair();
            pair.srcNeighbors = FunctionNode.neigborhoodAllocate();
            pair.destNeighbors = FunctionNode.neigborhoodAllocate();
            return pair;
        }
        Long srcNamespaceKey = srcNamespace.getID();
        NeighborGenerator.NeighborhoodPair pair = this.findPair(srcNamespaceKey, destNamespaceKey = Long.valueOf(destNamespace.getID()));
        if (pair == null) {
            pair = new NeighborGenerator.NeighborhoodPair();
            pair.srcNeighbors = this.buildNeighborhood(srcNamespace, srcNamespaceKey, this.sourceNodes, this.sourceSets);
            pair.destNeighbors = this.buildNeighborhood(destNamespace, destNamespaceKey, this.destNodes, this.destSets);
            this.cachePair(srcNamespaceKey, destNamespaceKey, pair);
        }
        if (!pair.isFilledOut && this.fillOutPairs(pair, 10000)) {
            pair.isFilledOut = true;
        }
        return pair;
    }

    private static class PairLabel
    implements Comparable<PairLabel> {
        public Long srcLabel;
        public Long destLabel;

        private PairLabel() {
        }

        @Override
        public int compareTo(PairLabel o) {
            int srcCmp = Long.compare(this.srcLabel, o.srcLabel);
            if (srcCmp != 0) {
                return srcCmp;
            }
            return Long.compare(this.destLabel, o.destLabel);
        }
    }
}

