/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.GlobalReferenceOffsetIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.ParsingIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.exception.CancelledException;
import java.util.NoSuchElementException;

class GlobalReferenceIterator
implements ParsingIterator<MsSymbolIterator> {
    private AbstractPdb pdb;
    private int symbolsStreamNumber;
    private GlobalReferenceOffsetIterator offsetIterator = null;
    private MsSymbolIterator currentGlobalSymbolIterator = null;

    public GlobalReferenceIterator(AbstractPdb pdb, PdbByteReader reader) throws CancelledException, PdbException {
        this.pdb = pdb;
        PdbDebugInfo debugInfo = pdb.getDebugInfo();
        if (debugInfo == null) {
            throw new PdbException("Cannot create " + String.valueOf(this.getClass()) + " because PDB Debug Info is null");
        }
        this.symbolsStreamNumber = debugInfo.getSymbolRecordsStreamNumber();
        if (this.symbolsStreamNumber == 65535) {
            throw new PdbException("Cannot create " + String.valueOf(this.getClass()) + " because there is no symbol stream");
        }
        this.offsetIterator = new GlobalReferenceOffsetIterator(reader);
    }

    @Override
    public boolean hasNext() throws CancelledException {
        if (this.currentGlobalSymbolIterator == null) {
            this.find();
        }
        return this.currentGlobalSymbolIterator != null;
    }

    @Override
    public MsSymbolIterator next() throws CancelledException, NoSuchElementException {
        if (this.hasNext()) {
            MsSymbolIterator returnGlobalSymbolIterator = this.currentGlobalSymbolIterator;
            this.currentGlobalSymbolIterator = null;
            return returnGlobalSymbolIterator;
        }
        throw new NoSuchElementException("next() called with no more elements");
    }

    @Override
    public MsSymbolIterator peek() throws CancelledException, NoSuchElementException {
        if (this.hasNext()) {
            return this.currentGlobalSymbolIterator;
        }
        throw new NoSuchElementException("peek() called with no more elements");
    }

    private void find() throws CancelledException {
        if (!this.offsetIterator.hasNext()) {
            this.currentGlobalSymbolIterator = null;
            return;
        }
        Long offset = this.offsetIterator.next();
        this.currentGlobalSymbolIterator = new MsSymbolIterator(this.pdb, this.symbolsStreamNumber, offset.intValue(), Integer.MAX_VALUE);
    }
}

