/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import java.util.HashMap;
import java.util.Map;

public enum Property {
    UNKNOWN("INVALID_PROPERTY", -1),
    BLANK("", 0),
    VIRTUAL("virtual", 1),
    STATIC("static", 2),
    FRIEND("friend", 3);

    private static final Map<Integer, Property> BY_VALUE;
    private final String label;
    private final int value;

    public String getString() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }

    public int getValue() {
        return this.value;
    }

    public static Property fromValue(int val) {
        return BY_VALUE.getOrDefault(val, UNKNOWN);
    }

    private Property(String label, int value) {
        this.label = label;
        this.value = value;
    }

    static {
        BY_VALUE = new HashMap<Integer, Property>();
        for (Property val : Property.values()) {
            BY_VALUE.put(val.value, val);
        }
    }
}

