/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.SymbolPathParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeProgramInterface;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractCompositeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ComplexTypeMapper {
    private Map<RecordNumber, RecordNumber> map = new HashMap<RecordNumber, RecordNumber>();

    public RecordNumber getMapped(RecordNumber recordNumber) {
        return this.map.getOrDefault(recordNumber, recordNumber);
    }

    public void mapTypes(PdbApplicator applicator) throws CancelledException {
        int indexNumber;
        Objects.requireNonNull(applicator, "applicator cannot be null");
        TypeProgramInterface typeProgramInterface = applicator.getPdb().getTypeProgramInterface();
        if (typeProgramInterface == null) {
            return;
        }
        HashMap<SymbolPath, Deque<NumFwdRef>> compositeFIFOsByPath = new HashMap<SymbolPath, Deque<NumFwdRef>>();
        HashMap<SymbolPath, Deque<NumFwdRef>> enumFIFOsByPath = new HashMap<SymbolPath, Deque<NumFwdRef>>();
        this.map = new HashMap<RecordNumber, RecordNumber>();
        int indexLimit = typeProgramInterface.getTypeIndexMaxExclusive();
        TaskMonitor monitor = applicator.getMonitor();
        monitor.initialize((long)(indexLimit - indexNumber));
        monitor.setMessage("PDB: Mapping Complex Types...");
        for (indexNumber = typeProgramInterface.getTypeIndexMin(); indexNumber < indexLimit; ++indexNumber) {
            monitor.checkCancelled();
            AbstractMsType type = typeProgramInterface.getRandomAccessRecord(indexNumber);
            if (type instanceof AbstractCompositeMsType) {
                AbstractCompositeMsType compositeType = (AbstractCompositeMsType)type;
                this.mapComplexTypesByPath(compositeFIFOsByPath, indexNumber, compositeType);
            } else if (type instanceof AbstractEnumMsType) {
                AbstractEnumMsType enumType = (AbstractEnumMsType)type;
                this.mapComplexTypesByPath(enumFIFOsByPath, indexNumber, enumType);
            }
            monitor.incrementProgress(1L);
        }
    }

    private void mapComplexTypesByPath(Map<SymbolPath, Deque<NumFwdRef>> typeFIFOsByPath, int indexNumber, AbstractComplexMsType complexType) {
        SymbolPath symbolPath = new SymbolPath(SymbolPathParser.parse((String)complexType.getName()));
        boolean isFwdRef = complexType.getMsProperty().isForwardReference();
        RecordNumber recordNumber = complexType.getRecordNumber();
        Deque<NumFwdRef> numTypeFIFO = typeFIFOsByPath.get(symbolPath);
        if (numTypeFIFO == null) {
            numTypeFIFO = new ArrayDeque<NumFwdRef>();
            typeFIFOsByPath.put(symbolPath, numTypeFIFO);
            if (!numTypeFIFO.add(new NumFwdRef(recordNumber, isFwdRef))) {
                // empty if block
            }
        } else {
            NumFwdRef firstNumFwdRef = numTypeFIFO.peekFirst();
            if (firstNumFwdRef.isFwd() == isFwdRef) {
                if (!numTypeFIFO.add(new NumFwdRef(recordNumber, isFwdRef))) {
                    // empty if block
                }
            } else {
                numTypeFIFO.removeFirst();
                if (isFwdRef) {
                    this.map.put(recordNumber, firstNumFwdRef.number());
                } else {
                    this.map.put(firstNumFwdRef.number(), recordNumber);
                }
                if (numTypeFIFO.isEmpty()) {
                    typeFIFOsByPath.remove(symbolPath);
                }
            }
        }
    }

    private record NumFwdRef(RecordNumber number, boolean isFwd) {
    }
}

