/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import ghidra.features.bsim.query.client.tables.CachedStatement;
import ghidra.features.bsim.query.client.tables.SQLComplexTable;
import ghidra.features.bsim.query.client.tables.SQLStringTable;
import ghidra.features.bsim.query.description.CategoryRecord;
import ghidra.features.bsim.query.description.ExecutableRecord;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ExeToCategoryTable
extends SQLComplexTable {
    private static final String INSERT_STMT = "INSERT INTO execattable (id_exe,id_type,id_category) VALUES(?,?,?)";
    private static final String SELECT_STMT = "SELECT ALL * FROM execattable WHERE id_exe = ?";
    private final SQLStringTable catstringtable;
    private final CachedStatement<PreparedStatement> selectCategoriesStatement = new CachedStatement();
    private final CachedStatement<PreparedStatement> insertExeCatStatement = new CachedStatement();

    public ExeToCategoryTable(SQLStringTable catstringtable) {
        super("execattable", "id_exe");
        this.catstringtable = catstringtable;
    }

    @Override
    public void close() {
        this.selectCategoriesStatement.close();
        this.insertExeCatStatement.close();
        super.close();
    }

    @Override
    public void create(Statement st) throws SQLException {
        st.executeUpdate("CREATE TABLE execattable (id_exe INTEGER,id_type INTEGER,id_category INTEGER)");
        st.executeUpdate("CREATE INDEX execatindex ON execattable (id_exe,id_category)");
    }

    @Override
    public void drop(Statement st) throws SQLException {
        throw new UnsupportedOperationException("ExeToCategoryTable may not be dropped");
    }

    @Override
    public long insert(Object ... arguments) throws SQLException {
        if (arguments == null || arguments.length != 2 || !(arguments[0] instanceof CategoryRecord)) {
            throw new IllegalArgumentException("Insert method for ExeToCategoryTable must take exactly 2 arguments: CategoryRecord and a long(id_exe)");
        }
        CategoryRecord catrec = (CategoryRecord)arguments[0];
        long id_type = this.catstringtable.writeString(catrec.getType());
        long id_category = this.catstringtable.writeString(catrec.getCategory());
        long exe_id = (Long)arguments[1];
        PreparedStatement s = this.insertExeCatStatement.prepareIfNeeded(() -> this.db.prepareStatement(INSERT_STMT));
        s.setInt(1, (int)exe_id);
        s.setInt(2, (int)id_type);
        s.setInt(3, (int)id_category);
        s.executeUpdate();
        return 0L;
    }

    protected static void extractCategoryRow(ResultSet pgres, CategoryRow res) throws SQLException {
        res.id_exe = pgres.getInt(1);
        res.id_type = pgres.getInt(2);
        res.id_category = pgres.getInt(3);
    }

    protected void extractCategoryRecords(ResultSet rs, List<CategoryRecord> vecres, int max) throws SQLException {
        ArrayList<CategoryRow> catrows = new ArrayList<CategoryRow>();
        boolean finished = false;
        while (rs.next()) {
            if (finished) continue;
            CategoryRow row = new CategoryRow();
            catrows.add(row);
            ExeToCategoryTable.extractCategoryRow(rs, row);
            if (max <= 0 || catrows.size() < max) continue;
            finished = true;
        }
        for (int i = 0; i < catrows.size(); ++i) {
            CategoryRow row = (CategoryRow)catrows.get(i);
            String type = this.catstringtable.getString(row.id_type);
            String category = this.catstringtable.getString(row.id_category);
            CategoryRecord catrec = new CategoryRecord(type, category);
            vecres.add(catrec);
        }
    }

    public List<CategoryRecord> queryExecutableCategories(long exeid, int max) throws SQLException {
        if (exeid == 0L) {
            throw new SQLException("ExecutableRecord does not have id");
        }
        PreparedStatement s = this.selectCategoriesStatement.prepareIfNeeded(() -> this.db.prepareStatement(SELECT_STMT));
        s.setInt(1, (int)exeid);
        try (ResultSet rs = s.executeQuery();){
            ArrayList<CategoryRecord> catvec = new ArrayList<CategoryRecord>();
            this.extractCategoryRecords(rs, catvec, max);
            ArrayList<CategoryRecord> arrayList = catvec;
            return arrayList;
        }
    }

    public void storeExecutableCategories(ExecutableRecord erec) throws SQLException {
        if (erec.isAlreadyStored()) {
            return;
        }
        List<CategoryRecord> catrecs = erec.getAllCategories();
        if (catrecs == null) {
            return;
        }
        long exeid = erec.getRowId().getLong();
        for (CategoryRecord catrec : catrecs) {
            this.insert(catrec, exeid);
        }
    }

    protected static class CategoryRow {
        public long id_exe;
        public long id_type;
        public long id_category;

        protected CategoryRow() {
        }
    }
}

