/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.trable;

import docking.widgets.trable.GTrableColumn;
import java.util.ArrayList;
import java.util.List;

public abstract class GTrableColumnModel<T> {
    private List<GTrableColumn<T, ?>> columns = new ArrayList();
    private int totalWidth;

    public GTrableColumnModel() {
        this.reloadColumns();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public GTrableColumn<T, ?> getColumn(int column) {
        return this.columns.get(column);
    }

    public int getPreferredWidth() {
        int preferredWidth = 0;
        for (GTrableColumn<T, ?> column : this.columns) {
            preferredWidth += column.getPreferredWidth();
        }
        return preferredWidth;
    }

    protected int computeWidth() {
        int width = 0;
        for (GTrableColumn<T, ?> column : this.columns) {
            width += column.getWidth();
        }
        return width;
    }

    protected void reloadColumns() {
        this.columns.clear();
        this.populateColumns(this.columns);
        this.computeColumnStarts();
        this.totalWidth = this.computeWidth();
    }

    protected abstract void populateColumns(List<GTrableColumn<T, ?>> var1);

    protected void removeAllColumns() {
        this.columns.removeAll(this.columns);
        this.totalWidth = 0;
    }

    protected int getWidth() {
        return this.totalWidth;
    }

    protected int getIndex(int x) {
        for (int i = this.columns.size() - 1; i >= 0; --i) {
            GTrableColumn<T, ?> column = this.columns.get(i);
            if (x < column.getStartX()) continue;
            return i;
        }
        return 0;
    }

    protected void setWidth(int newWidth) {
        int diff = newWidth - this.totalWidth;
        if (diff == 0) {
            return;
        }
        if (diff > 0) {
            int amount = this.growLeftPreferred(this.columns.size() - 1, diff);
            this.growLeft(this.columns.size() - 1, amount);
        } else {
            this.shrinkLeft(this.columns.size() - 1, -diff);
        }
        this.computeColumnStarts();
    }

    void moveColumnStart(int columnIndex, int x) {
        GTrableColumn<T, ?> column = this.columns.get(columnIndex);
        int currentStartX = column.getStartX();
        int diff = x - currentStartX;
        if (diff > 0 && this.canGrowLeft(columnIndex - 1)) {
            int actualAmount = this.shrinkRight(columnIndex, diff);
            this.growLeft(columnIndex - 1, actualAmount);
        } else if (diff < 0 && this.canGrowRight(columnIndex)) {
            int actualAmount = this.shrinkLeft(columnIndex - 1, -diff);
            this.growRight(columnIndex, actualAmount);
        }
        this.computeColumnStarts();
    }

    private boolean canGrowLeft(int index) {
        return this.canGrow(0, index);
    }

    private boolean canGrowRight(int index) {
        return this.canGrow(index, this.columns.size() - 1);
    }

    private boolean canGrow(int index1, int index2) {
        for (int i = index1; i <= index2; ++i) {
            if (!this.columns.get(i).isResizable()) continue;
            return true;
        }
        return false;
    }

    private void computeColumnStarts() {
        int x = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            GTrableColumn<T, ?> column = this.columns.get(i);
            column.setStartX(x);
            int width = column.getWidth();
            x += width;
        }
        this.totalWidth = x;
        this.modelColumnsChaged();
    }

    protected void modelColumnsChaged() {
    }

    private void growRight(int columnIndex, int amount) {
        for (int i = columnIndex; i < this.columns.size(); ++i) {
            GTrableColumn<T, ?> column = this.columns.get(i);
            if (!column.isResizable()) continue;
            column.setWidth(column.getWidth() + amount);
            return;
        }
    }

    private void growLeft(int columnIndex, int amount) {
        for (int i = columnIndex; i >= 0; --i) {
            GTrableColumn<T, ?> column = this.columns.get(i);
            if (!column.isResizable()) continue;
            column.setWidth(column.getWidth() + amount);
            return;
        }
    }

    private int growLeftPreferred(int columnIndex, int amount) {
        for (int i = columnIndex; i >= 0 && amount > 0; --i) {
            int preferredWidth;
            int width;
            GTrableColumn<T, ?> column = this.columns.get(i);
            if (!column.isResizable() || (width = column.getWidth()) >= (preferredWidth = column.getPreferredWidth())) continue;
            int adjustment = Math.min(amount, preferredWidth - width);
            column.setWidth(width + adjustment);
            amount -= adjustment;
        }
        return amount;
    }

    private int growRightPreferred(int columnIndex, int amount) {
        for (int i = columnIndex; i < this.columns.size() && amount > 0; ++i) {
            int preferredWidth;
            int width;
            GTrableColumn<T, ?> column = this.columns.get(i);
            if (!column.isResizable() || (width = column.getWidth()) >= (preferredWidth = column.getPreferredWidth())) continue;
            int adjustment = Math.min(amount, preferredWidth - width);
            column.setWidth(width + adjustment);
            amount -= adjustment;
        }
        return amount;
    }

    private int shrinkLeft(int columnIndex, int amount) {
        int remainingAmount = amount;
        for (int i = columnIndex; i >= 0 && remainingAmount > 0; remainingAmount -= this.shrinkColumn(i, remainingAmount), --i) {
        }
        return amount - remainingAmount;
    }

    private int shrinkRight(int columnIndex, int amount) {
        int remainingAmount = amount;
        for (int i = columnIndex; i < this.columns.size() && remainingAmount > 0; remainingAmount -= this.shrinkColumn(i, remainingAmount), ++i) {
        }
        return amount - remainingAmount;
    }

    private int shrinkColumn(int columnIndex, int amount) {
        int minWidth;
        GTrableColumn<T, ?> column = this.columns.get(columnIndex);
        if (!column.isResizable()) {
            return 0;
        }
        int currentWidth = column.getWidth();
        if (currentWidth >= (minWidth = column.getMinWidth()) + amount) {
            column.setWidth(currentWidth - amount);
            return amount;
        }
        column.setWidth(minWidth);
        return currentWidth - minWidth;
    }
}

