/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.space;

import generic.util.FlattenedIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.LockHold;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;

public interface DBTraceDelegatingManager<M> {
    default public void checkIsInMemory(AddressSpace space) {
        if (!space.isMemorySpace() && space != Address.NO_ADDRESS.getAddressSpace()) {
            throw new IllegalArgumentException("Address must be in memory or NO_ADDRESS. Got " + String.valueOf(space));
        }
    }

    default public <T, E extends Throwable> T delegateWrite(AddressSpace space, ExcFunction<M, T, E> func) throws E {
        this.checkIsInMemory(space);
        try (LockHold hold = LockHold.lock((Lock)this.writeLock());){
            M m = this.getForSpace(space, true);
            T t = func.apply(m);
            return t;
        }
    }

    default public <E extends Throwable> void delegateWriteV(AddressSpace space, ExcConsumer<M, E> func) throws E {
        this.checkIsInMemory(space);
        try (LockHold hold = LockHold.lock((Lock)this.writeLock());){
            M m = this.getForSpace(space, true);
            func.accept(m);
        }
    }

    default public int delegateWriteI(AddressSpace space, ToIntFunction<M> func) {
        this.checkIsInMemory(space);
        try (LockHold hold = LockHold.lock((Lock)this.writeLock());){
            M m = this.getForSpace(space, true);
            int n = func.applyAsInt(m);
            return n;
        }
    }

    default public <E extends Throwable> void delegateWriteAll(Iterable<M> spaces, ExcConsumer<M, E> func) throws E {
        try (LockHold hold = LockHold.lock((Lock)this.writeLock());){
            for (M m : spaces) {
                func.accept(m);
            }
        }
    }

    default public <T, E extends Throwable> T delegateRead(AddressSpace space, ExcFunction<M, T, E> func) throws E {
        return this.delegateRead(space, func, null);
    }

    default public <T, E extends Throwable> T delegateRead(AddressSpace space, ExcFunction<M, T, E> func, T ifNull) throws E {
        this.checkIsInMemory(space);
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            M m = this.getForSpace(space, false);
            if (m == null) {
                T t = ifNull;
                return t;
            }
            T t = func.apply(m);
            return t;
        }
    }

    default public <T, E extends Throwable> T delegateReadOr(AddressSpace space, ExcFunction<M, T, E> func, ExcSupplier<T, E> ifNull) throws E {
        this.checkIsInMemory(space);
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            M m = this.getForSpace(space, false);
            if (m == null) {
                T t = ifNull.get();
                return t;
            }
            T t = func.apply(m);
            return t;
        }
    }

    default public int delegateReadI(AddressSpace space, ToIntFunction<M> func, int ifNull) {
        this.checkIsInMemory(space);
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            M m = this.getForSpace(space, false);
            if (m == null) {
                int n = ifNull;
                return n;
            }
            int n = func.applyAsInt(m);
            return n;
        }
    }

    default public int delegateReadI(AddressSpace space, ToIntFunction<M> func, IntSupplier ifNull) {
        this.checkIsInMemory(space);
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            M m = this.getForSpace(space, false);
            if (m == null) {
                int n = ifNull.getAsInt();
                return n;
            }
            int n = func.applyAsInt(m);
            return n;
        }
    }

    default public boolean delegateReadB(AddressSpace space, Predicate<M> func, boolean ifNull) {
        this.checkIsInMemory(space);
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            M m = this.getForSpace(space, false);
            if (m == null) {
                boolean bl = ifNull;
                return bl;
            }
            boolean bl = func.test(m);
            return bl;
        }
    }

    default public <E extends Throwable> void delegateDeleteV(AddressSpace space, ExcConsumer<M, E> func) throws E {
        this.checkIsInMemory(space);
        try (LockHold hold = LockHold.lock((Lock)this.writeLock());){
            M m = this.getForSpace(space, false);
            if (m == null) {
                return;
            }
            func.accept(m);
        }
    }

    default public boolean delegateDeleteB(AddressSpace space, Predicate<M> func, boolean ifNull) {
        this.checkIsInMemory(space);
        try (LockHold hold = LockHold.lock((Lock)this.writeLock());){
            M m = this.getForSpace(space, false);
            if (m == null) {
                boolean bl = ifNull;
                return bl;
            }
            boolean bl = func.test(m);
            return bl;
        }
    }

    default public <T> T delegateFirst(Iterable<M> spaces, Function<M, T> func) {
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            for (M m : spaces) {
                T t = func.apply(m);
                if (t == null) continue;
                T t2 = t;
                return t2;
            }
            Iterator<M> iterator = null;
            return (T)iterator;
        }
    }

    default public <T> Collection<T> delegateCollection(final Iterable<M> spaces, final Function<M, Collection<T>> func) {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return FlattenedIterator.start(spaces.iterator(), func.andThen(Iterable::iterator));
            }

            @Override
            public int size() {
                try (LockHold hold = LockHold.lock((Lock)DBTraceDelegatingManager.this.readLock());){
                    int sum = 0;
                    for (Object m : spaces) {
                        sum += ((Collection)func.apply(m)).size();
                    }
                    int n = sum;
                    return n;
                }
            }

            @Override
            public boolean isEmpty() {
                try (LockHold hold = LockHold.lock((Lock)DBTraceDelegatingManager.this.readLock());){
                    for (Object m : spaces) {
                        if (((Collection)func.apply(m)).isEmpty()) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        };
    }

    default public <T> HashSet<T> delegateHashSet(Iterable<M> spaces, Function<M, Collection<T>> func) {
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            HashSet<T> result = new HashSet<T>();
            for (M m : spaces) {
                result.addAll(func.apply(m));
            }
            HashSet<T> hashSet = result;
            return hashSet;
        }
    }

    default public <E extends Throwable> AddressSetView delegateAddressSet(Iterable<M> spaces, ExcFunction<M, AddressSetView, E> func) throws E {
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            AddressSet result = new AddressSet();
            for (M m : spaces) {
                result.add(func.apply(m));
            }
            AddressSet addressSet = result;
            return addressSet;
        }
    }

    default public <E extends Throwable> boolean delegateAny(Iterable<M> spaces, ExcPredicate<M, E> func) throws E {
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            for (M m : spaces) {
                if (!func.test(m)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public Lock readLock();

    public Lock writeLock();

    public M getForSpace(AddressSpace var1, boolean var2);

    public static interface ExcFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    public static interface ExcConsumer<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }

    public static interface ExcSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    public static interface ExcPredicate<T, E extends Throwable> {
        public boolean test(T var1) throws E;
    }
}

