/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectEventIdGenerator;
import ghidra.framework.model.EventType;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.guest.TraceGuestPlatform;
import ghidra.trace.model.guest.TraceGuestPlatformMappedRange;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.listing.TraceInstruction;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.symbol.TraceSymbolWithLifespan;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.UniversalID;

public interface TraceEvent<T, U>
extends EventType {
    default public TraceChangeRecord<T, U> cast(DomainObjectChangeRecord rec) {
        return (TraceChangeRecord)rec;
    }

    public static enum TracePlatformMappingEvent implements TraceEvent<TraceGuestPlatform, TraceGuestPlatformMappedRange>
    {
        PLATFORM_MAPPING_ADDED,
        PLATFORM_MAPPING_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TracePlatformEvent implements TraceEvent<TraceGuestPlatform, Void>
    {
        PLATFORM_ADDED,
        PLATFORM_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceSnapshotEvent implements TraceEvent<TraceSnapshot, Void>
    {
        SNAPSHOT_ADDED,
        SNAPSHOT_CHANGED,
        SNAPSHOT_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceThreadLifespanEvent implements TraceEvent<TraceThread, Lifespan>
    {
        THREAD_LIFESPAN_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceThreadEvent implements TraceEvent<TraceThread, Void>
    {
        THREAD_ADDED,
        THREAD_CHANGED,
        THREAD_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceSymbolLifespanEvent implements TraceEvent<TraceSymbolWithLifespan, Lifespan>
    {
        SYMBOL_LIFESPAN_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceSymbolAddressEvent implements TraceEvent<TraceSymbol, Address>
    {
        SYMBOL_ADDRESS_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceSymbolRefEvent implements TraceEvent<TraceSymbol, TraceReference>
    {
        SYMBOL_ASSOCIATION_ADDED,
        SYMBOL_ASSOCIATION_REMOVED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceSymbolNamespaceEvent implements TraceEvent<TraceSymbol, TraceNamespaceSymbol>
    {
        SYMBOL_PARENT_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceSymbolStringEvent implements TraceEvent<TraceSymbol, String>
    {
        SYMBOL_RENAMED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceSymbolSymEvent implements TraceEvent<TraceSymbol, TraceSymbol>
    {
        SYMBOL_PRIMARY_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceSymbolSourceEvent implements TraceEvent<TraceSymbol, SourceType>
    {
        SYMBOL_SOURCE_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceSymbolEvent implements TraceEvent<TraceSymbol, Void>
    {
        SYMBOL_ADDED,
        SYMBOL_CHANGED,
        SYMBOL_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceTypeArchiveEvent implements TraceEvent<UniversalID, Void>
    {
        SOURCE_TYPE_ARCHIVE_ADDED,
        SOURCE_TYPE_ARCHIVE_CHANGED,
        SOURCE_TYPE_ARCHIVE_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceMappingEvent implements TraceEvent<TraceStaticMapping, Void>
    {
        MAPPING_ADDED,
        MAPPING_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceStackLongEvent implements TraceEvent<TraceStack, Long>
    {
        STACK_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceStackEvent implements TraceEvent<TraceStack, Void>
    {
        STACK_ADDED,
        STACK_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceReferenceBoolEvent implements TraceEvent<TraceReference, Boolean>
    {
        REFERENCE_PRIMARY_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceReferenceLifespanEvent implements TraceEvent<TraceReference, Lifespan>
    {
        REFERENCE_LIFESPAN_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceReferenceEvent implements TraceEvent<TraceAddressSnapRange, TraceReference>
    {
        REFERENCE_ADDED,
        REFERENCE_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceSectionEvent implements TraceEvent<TraceSection, Void>
    {
        SECTION_ADDED,
        SECTION_CHANGED,
        SECTION_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceModuleLifespanEvent implements TraceEvent<TraceModule, Lifespan>
    {
        MODULE_LIFESPAN_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceModuleEvent implements TraceEvent<TraceModule, Void>
    {
        MODULE_ADDED,
        MODULE_CHANGED,
        MODULE_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceMemoryStateEvent implements TraceEvent<TraceAddressSnapRange, TraceMemoryState>
    {
        BYTES_STATE_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceOverlaySpaceEvent implements TraceEvent<Trace, AddressSpace>
    {
        OVERLAY_ADDED,
        OVERLAY_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceMemoryRegionLifespanEvent implements TraceEvent<TraceMemoryRegion, Lifespan>
    {
        REGION_LIFESPAN_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceMemoryRegionEvent implements TraceEvent<TraceMemoryRegion, Void>
    {
        REGION_ADDED,
        REGION_CHANGED,
        REGION_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceBytesEvent implements TraceEvent<TraceAddressSnapRange, byte[]>
    {
        BYTES_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceInstructionIntEvent implements TraceEvent<TraceInstruction, Integer>
    {
        INSTRUCTION_LENGTH_OVERRIDE_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceInstructionBoolEvent implements TraceEvent<TraceInstruction, Boolean>
    {
        INSTRUCTION_FALL_THROUGH_OVERRIDE_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceInstructionFlowEvent implements TraceEvent<TraceInstruction, FlowOverride>
    {
        INSTRUCTION_FLOW_OVERRIDE_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceDataTypeStringEvent implements TraceEvent<Long, String>
    {
        DATA_TYPE_RENAMED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceDataTypePathEvent implements TraceEvent<Long, DataTypePath>
    {
        DATA_TYPE_REPLACED,
        DATA_TYPE_MOVED,
        DATA_TYPE_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceDataTypeEvent implements TraceEvent<Long, DataType>
    {
        DATA_TYPE_ADDED,
        DATA_TYPE_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceCompositeDataLifespanEvent implements TraceEvent<TraceData, Lifespan>
    {
        COMPOSITE_DATA_LIFESPAN_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceCompositeDataEvent implements TraceEvent<TraceAddressSnapRange, TraceData>
    {
        COMPOSITE_DATA_ADDED,
        COMPOSITE_DATA_REMOVED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceCommentEvent implements TraceEvent<TraceAddressSnapRange, String>
    {
        PLATE_COMMENT_CHANGED,
        PRE_COMMENT_CHANGED,
        POST_COMMENT_CHANGED,
        EOL_COMMENT_CHANGED,
        REPEATABLE_COMMENT_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceCodeDataSettingsEvent implements TraceEvent<TraceAddressSnapRange, Void>
    {
        CODE_DATA_SETTINGS_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceCodeDataTypeEvent implements TraceEvent<TraceAddressSnapRange, Long>
    {
        CODE_DATA_TYPE_REPLACED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceCodeFragmentEvent implements TraceEvent<TraceAddressSnapRange, ProgramFragment>
    {
        CODE_FRAGMENT_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceCodeLifespanEvent implements TraceEvent<TraceCodeUnit, Lifespan>
    {
        CODE_LIFESPAN_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceCodeEvent implements TraceEvent<TraceAddressSnapRange, TraceCodeUnit>
    {
        CODE_ADDED,
        CODE_REMOVED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceTypeCategoryStringEvent implements TraceEvent<Long, String>
    {
        TYPE_CATEGORY_RENAMED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceTypeCategoryPathEvent implements TraceEvent<Long, CategoryPath>
    {
        TYPE_CATEGORY_MOVED,
        TYPE_CATEGORY_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceTypeCategoryEvent implements TraceEvent<Long, Category>
    {
        TYPE_CATEGORY_ADDED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceBreakpointLifespanEvent implements TraceEvent<TraceBreakpointLocation, Lifespan>
    {
        BREAKPOINT_LIFESPAN_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceBreakpointEvent implements TraceEvent<TraceBreakpointLocation, Void>
    {
        BREAKPOINT_ADDED,
        BREAKPOINT_CHANGED,
        BREAKPOINT_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceBookmarkLifespanEvent implements TraceEvent<TraceBookmark, Lifespan>
    {
        BOOKMARK_LIFESPAN_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceBookmarkEvent implements TraceEvent<TraceBookmark, Void>
    {
        BOOKMARK_ADDED,
        BOOKMARK_CHANGED,
        BOOKMARK_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceBookmarkTypeEvent implements TraceEvent<TraceBookmarkType, Void>
    {
        BOOKMARK_TYPE_ADDED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceObjectValueLifespanEvent implements TraceEvent<TraceObjectValue, Lifespan>
    {
        VALUE_LIFESPAN_CHANGED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceObjectValueEvent implements TraceEvent<TraceObjectValue, Void>
    {
        VALUE_CREATED,
        VALUE_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }

    public static enum TraceObjectEvent implements TraceEvent<TraceObject, Void>
    {
        OBJECT_CREATED,
        OBJECT_LIFE_CHANGED,
        OBJECT_DELETED;

        private final int id = DomainObjectEventIdGenerator.next();

        public int getId() {
            return this.id;
        }
    }
}

