/*
 * Decompiled with CFR 0.152.
 */
package datagraph;

import datagraph.DataGraphProvider;
import datagraph.DegSharedConfig;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.ListingActionContext;
import ghidra.app.events.AbstractLocationPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Data;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.util.HashSet;
import java.util.Set;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Graph", shortDescription="Data Graph", description="\tPlugin for displaying graphs of data objects in memory. From any data object in the\n\tlisting, the user can display a graph of that data object. Initially, a graph will be shown\n\twith one vertex that has a scrollable view of the values in memory associated with that data.\n\tAlso, any pointers or references from or to that data can be explored by following the\n\treferences and creating additional vertices for the referenced code or data.\n", eventsConsumed={ProgramLocationPluginEvent.class}, eventsProduced={ProgramLocationPluginEvent.class})
public class DataGraphPlugin
extends ProgramPlugin {
    private static final String NAVIGATE_IN = "Navigate In";
    private static final String NAVIGATE_OUT = "Navigate Out";
    private static final String COMPACT_FORMAT = "Compact Format";
    private static final String SHOW_POPUPS = "Show Popups";
    private Set<DataGraphProvider> activeProviders = new HashSet<DataGraphProvider>();
    private DegSharedConfig sharedConfig = new DegSharedConfig();

    public DataGraphPlugin(PluginTool plugintool) {
        super(plugintool);
        this.createActions();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof AbstractLocationPluginEvent) {
            AbstractLocationPluginEvent ev = (AbstractLocationPluginEvent)event;
            ProgramLocation location = ev.getLocation();
            this.setLocation(location);
        }
    }

    public void setLocation(ProgramLocation location) {
        this.activeProviders.forEach(p -> p.setLocation(location));
    }

    public void readConfigState(SaveState saveState) {
        this.sharedConfig.setNavigateIn(saveState.getBoolean(NAVIGATE_IN, false));
        this.sharedConfig.setNavigateOut(saveState.getBoolean(NAVIGATE_OUT, true));
        this.sharedConfig.setCompactFormat(saveState.getBoolean(COMPACT_FORMAT, true));
        this.sharedConfig.setShowPopups(saveState.getBoolean(SHOW_POPUPS, true));
    }

    public void writeConfigState(SaveState saveState) {
        saveState.putBoolean(NAVIGATE_IN, this.sharedConfig.isNavigateIn());
        saveState.putBoolean(NAVIGATE_OUT, this.sharedConfig.isNavigateOut());
        saveState.putBoolean(COMPACT_FORMAT, this.sharedConfig.useCompactFormat());
        saveState.putBoolean(SHOW_POPUPS, this.sharedConfig.isShowPopups());
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Display Data Graph", this.getName()).menuPath(new String[]{"&Graph", "Data"})).menuGroup("Graph", "Data")).popupMenuPath(new String[]{"Data", "Display Data Graph"})).keyBinding("ctrl G")).helpLocation(new HelpLocation("DataGraphPlugin", "Data_Graph"))).withContext(ListingActionContext.class).enabledWhen(this::isGraphActionEnabled).onAction(this::showDataGraph).buildAndInstall((Tool)this.tool);
    }

    protected boolean isGraphActionEnabled(ListingActionContext context) {
        return context.getCodeUnit() instanceof Data;
    }

    private void showDataGraph(ListingActionContext context) {
        Data data = (Data)context.getCodeUnit();
        data = this.getTopLevelData(data);
        DataGraphProvider provider = new DataGraphProvider(this, context.getNavigatable(), data, this.sharedConfig);
        this.activeProviders.add(provider);
        this.tool.showComponentProvider((ComponentProvider)provider, true);
    }

    private Data getTopLevelData(Data data) {
        Data parent = data.getParent();
        while (parent != null) {
            data = parent;
            parent = data.getParent();
        }
        return data;
    }

    void removeProvider(DataGraphProvider provider) {
        this.activeProviders.remove((Object)provider);
    }
}

