/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph;

import functioncalls.graph.FcgDirection;
import functioncalls.graph.FcgLevel;
import functioncalls.graph.FcgVertexExpansionListener;
import functioncalls.graph.FcgVertexShapeProvider;
import functioncalls.plugin.FcgOptions;
import ghidra.base.graph.CircleWithLabelVertex;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import java.util.Objects;
import javax.swing.JButton;

public class FcgVertex
extends CircleWithLabelVertex {
    private Function function;
    private FcgLevel level;
    private FcgOptions options;
    private FcgVertexShapeProvider fcgShapeProvider;

    public FcgVertex(Function function, FcgLevel level, FcgVertexExpansionListener expansionListener, FcgOptions options) {
        super(function.getName());
        this.function = function;
        this.level = level;
        this.options = options;
        this.fcgShapeProvider = new FcgVertexShapeProvider(this, expansionListener);
        this.shapeProvider = this.fcgShapeProvider;
    }

    public Function getFunction() {
        return this.function;
    }

    public Address getAddress() {
        return this.function.getEntryPoint();
    }

    public FcgOptions getOptions() {
        return this.options;
    }

    public FcgLevel getLevel() {
        return this.level;
    }

    public int getDegree() {
        return this.level.getRow();
    }

    public FcgDirection getDirection() {
        return this.level.getDirection();
    }

    public void setHovered(boolean hovered) {
        super.setHovered(hovered);
        this.fcgShapeProvider.setTogglesVisible(hovered);
    }

    public JButton getIncomingToggleButton() {
        return this.shapeProvider.getIncomingToggleButton();
    }

    public JButton getOutgoingToggleButton() {
        return this.shapeProvider.getOutgoingToggleButton();
    }

    public void setHasIncomingReferences(boolean hasIncoming) {
        this.fcgShapeProvider.setHasIncomingReferences(hasIncoming);
    }

    public void setHasOutgoingReferences(boolean hasOutgoing) {
        this.fcgShapeProvider.setHasOutgoingReferences(hasOutgoing);
    }

    public void setTooManyIncomingReferences(boolean tooMany) {
        this.fcgShapeProvider.setTooManyIncomingReferences(tooMany);
    }

    public void setTooManyOutgoingReferences(boolean tooMany) {
        this.fcgShapeProvider.setTooManyOutgoingReferences(tooMany);
    }

    public boolean hasTooManyIncomingReferences() {
        return this.fcgShapeProvider.hasTooManyIncomingReferences();
    }

    public boolean hasTooManyOutgoingReferences() {
        return this.fcgShapeProvider.hasTooManyOutgoingReferences();
    }

    public boolean isIncomingExpanded() {
        return this.fcgShapeProvider.isIncomingExpanded();
    }

    public boolean isOutgoingExpanded() {
        return this.fcgShapeProvider.isOutgoingExpanded();
    }

    public boolean isExpanded() {
        return this.fcgShapeProvider.isExpanded();
    }

    public boolean canExpand() {
        return this.fcgShapeProvider.canExpand();
    }

    public boolean canExpandIncomingReferences() {
        return this.fcgShapeProvider.canExpandIncomingReferences();
    }

    public boolean canExpandOutgoingReferences() {
        return this.fcgShapeProvider.canExpandOutgoingReferences();
    }

    public void setIncomingExpanded(boolean setExpanded) {
        this.fcgShapeProvider.setIncomingExpanded(setExpanded);
    }

    public void setOutgoingExpanded(boolean setExpanded) {
        this.fcgShapeProvider.setOutgoingExpanded(setExpanded);
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return Objects.hash(this.function);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FcgVertex other = (FcgVertex)((Object)obj);
        return Objects.equals(this.function, other.function);
    }

    public void dispose() {
        this.function = null;
        super.dispose();
    }
}

