/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.auth;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.rzo.netty.ahessian.auth.AuthToken;

public class ServerAuthFilter
extends ChannelInboundHandlerAdapter {
    private AuthToken _token = null;
    private boolean _authenticated = false;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerAuthFilter.class);

    public ServerAuthFilter(AuthToken token) {
        this.setToken(token);
    }

    public void setToken(AuthToken token) {
        this._token = token;
    }

    public void channelRead(ChannelHandlerContext ctx, Object e) throws Exception {
        if (!this._authenticated) {
            int result = this._token.authenticate(ctx, (ByteBuf)e);
            if (result == 2) {
                logger.warn("authentication failed -> close connection");
                ctx.channel().close();
            } else if (result == 1) {
                this._authenticated = true;
            }
        } else {
            ctx.fireChannelRead(e);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this._token.disconnected();
        ctx.fireChannelInactive();
    }
}

