/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.datatypes;

import docking.widgets.button.GRadioButton;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.app.merge.MergeConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;

class CategoryConflictPanel
extends JPanel {
    public static final String LATEST_BUTTON_NAME = "LatestVersionRB";
    public static final String CHECKED_OUT_BUTTON_NAME = "CheckedOutVersionRB";
    public static final String ORIGINAL_BUTTON_NAME = "OriginalVersionRB";
    private ChangeListener listener;
    private JRadioButton latestRB;
    private JRadioButton myRB;
    private JRadioButton originalRB;
    private ButtonGroup group;
    private JPanel rbPanel;
    private JLabel categoryLabel;

    CategoryConflictPanel(String title, ChangeListener listener) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.create();
        this.listener = listener;
    }

    void setConflictInfo(String categoryName, String latestStr, String myStr, String origStr) {
        this.categoryLabel.setText(categoryName);
        this.group.remove(this.latestRB);
        this.group.remove(this.myRB);
        this.group.remove(this.originalRB);
        this.latestRB.setText(latestStr);
        this.myRB.setText(myStr);
        this.originalRB.setText(origStr);
        this.latestRB.setSelected(false);
        this.myRB.setSelected(false);
        this.originalRB.setSelected(false);
        this.addToButtonGroup();
    }

    int getSelectedOption() {
        if (this.latestRB.isSelected()) {
            return 0;
        }
        if (this.myRB.isSelected()) {
            return 1;
        }
        if (this.originalRB.isSelected()) {
            return 2;
        }
        return -1;
    }

    private void create() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.categoryLabel = new GDLabel("CategoryName");
        this.categoryLabel.setForeground((Color)MergeConstants.CONFLICT_COLOR);
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add((Component)new GLabel("Category: "));
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add(this.categoryLabel);
        this.latestRB = new GRadioButton("Use Latest");
        this.myRB = new GRadioButton("Use My Version");
        this.originalRB = new GRadioButton("Use Original");
        this.latestRB.setName(LATEST_BUTTON_NAME);
        this.myRB.setName(CHECKED_OUT_BUTTON_NAME);
        this.originalRB.setName(ORIGINAL_BUTTON_NAME);
        this.group = new ButtonGroup();
        this.addToButtonGroup();
        this.rbPanel = new JPanel();
        this.rbPanel.setLayout(new BoxLayout(this.rbPanel, 1));
        this.rbPanel.add(this.latestRB);
        this.rbPanel.add(this.myRB);
        this.rbPanel.add(this.originalRB);
        panel.add((Component)labelPanel, "North");
        panel.add((Component)this.rbPanel, "Center");
        this.add(panel);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CategoryConflictPanel.this.listener != null) {
                    CategoryConflictPanel.this.listener.stateChanged(null);
                }
            }
        };
        this.latestRB.addItemListener(itemListener);
        this.myRB.addItemListener(itemListener);
        this.originalRB.addItemListener(itemListener);
    }

    private void addToButtonGroup() {
        this.group.add(this.latestRB);
        this.group.add(this.myRB);
        this.group.add(this.originalRB);
    }
}

