/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class ObjectiveC1_MessageAnalyzer
extends AbstractAnalyzer {
    private static final String DESCRIPTION = "An analyzer for extracting _objc_msgSend information.";
    private static final String NAME = "Objective-C Message";

    public ObjectiveC1_MessageAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(new AnalysisPriority(10000000));
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        CurrentState state = new CurrentState(this, program);
        monitor.initialize(set.getNumAddresses());
        int progress = 0;
        AddressIterator iterator = set.getAddresses(true);
        while (iterator.hasNext() && !monitor.isCancelled()) {
            monitor.setProgress((long)(++progress));
            Address address = iterator.next();
            Function function = program.getListing().getFunctionAt(address);
            try {
                this.inspectFunction(program, function, state, monitor);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    @Override
    public boolean canAnalyze(Program program) {
        return ObjectiveC1_Constants.isObjectiveC(program);
    }

    private void inspectFunction(Program program, Function function, CurrentState state, TaskMonitor monitor) {
        if (function == null) {
            return;
        }
        InstructionIterator instructionIterator = program.getListing().getInstructions(function.getBody(), true);
        while (instructionIterator.hasNext() && !monitor.isCancelled()) {
            String eolComment;
            Instruction instruction = instructionIterator.next();
            if (!this.isCallingObjcMsgSend(instruction) || (eolComment = instruction.getComment(CommentType.EOL)) != null) continue;
            this.markupInstruction(instruction, state, monitor);
        }
    }

    private boolean isCallingObjcMsgSend(Instruction instruction) {
        if (instruction.getNumOperands() != 1) {
            return false;
        }
        Reference reference = instruction.getPrimaryReference(0);
        if (reference == null) {
            return false;
        }
        if (!reference.getReferenceType().isCall() && !reference.getReferenceType().isJump()) {
            return false;
        }
        SymbolTable symbolTable = instruction.getProgram().getSymbolTable();
        Symbol symbol = symbolTable.getPrimarySymbol(reference.getToAddress());
        return this.isObjcNameMatch(symbol);
    }

    private boolean isObjcNameMatch(Symbol symbol) {
        String name = symbol.getName();
        return name.startsWith("_objc_msgSend") || name.equals("_read$UNIX2003") || name.startsWith("thunk_objc_msgSend");
    }

    private void markupInstruction(Instruction instruction, CurrentState state, TaskMonitor monitor) {
        Address fromAddress = instruction.getMinAddress();
        Function function = state.program.getListing().getFunctionContaining(fromAddress);
        if (function == null) {
            return;
        }
        state.reset();
        InstructionIterator iter = state.program.getListing().getInstructions(fromAddress, false);
        while (iter.hasNext() && !monitor.isCancelled()) {
            Reference[] opRefs;
            Instruction instructionBefore = iter.next();
            if (!function.getBody().contains(instructionBefore.getMinAddress())) break;
            if (!this.isValidInstruction(instructionBefore) || (opRefs = instructionBefore.getOperandReferences(1)).length != 1) continue;
            Address toAddress = opRefs[0].getToAddress();
            MemoryBlock block = state.program.getMemory().getBlock(toAddress);
            if (block == null) continue;
            this.pullNameThrough(state, toAddress, null);
            if (!state.isValid()) continue;
            instruction.setComment(CommentType.EOL, state.toString());
            this.setReference(fromAddress, state);
            break;
        }
    }

    private void setReference(Address fromAddress, CurrentState state) {
        SymbolTable symbolTable = state.program.getSymbolTable();
        Symbol classSymbol = symbolTable.getClassSymbol(state.currentClassName, (Namespace)null);
        if (classSymbol == null) {
            return;
        }
        Namespace namespace = (Namespace)classSymbol.getObject();
        List functionSymbols = symbolTable.getSymbols(state.currentMethodName, namespace);
        if (functionSymbols.size() >= 1) {
            Address toAddress = ((Symbol)functionSymbols.get(0)).getAddress();
            ReferenceManager referenceManager = state.program.getReferenceManager();
            Reference reference = referenceManager.addMemoryReference(fromAddress, toAddress, (RefType)RefType.UNCONDITIONAL_CALL, SourceType.ANALYSIS, 0);
            referenceManager.setPrimary(reference, true);
        }
    }

    String pullNameThrough(CurrentState state, Address address, Namespace space) {
        Reference[] references;
        MemoryBlock block = state.program.getMemory().getBlock(address);
        if (block == null) {
            return null;
        }
        if (block.getName().equals("__cstring")) {
            return ObjectiveC1_Utilities.createString(state.program, address);
        }
        Data data = state.program.getListing().getDataAt(address);
        if (data == null) {
            data = state.program.getListing().getDataContaining(address);
            if (data == null) {
                return null;
            }
            if ((data = data.getComponentContaining((int)address.subtract(data.getAddress()))) == null) {
                return null;
            }
        }
        if ((references = data.getValueReferences()).length == 0) {
            return null;
        }
        if (address.equals((Object)references[0].getToAddress())) {
            return null;
        }
        if (this.isClassBlock(block)) {
            space = state.idNamespace;
        } else if (this.isMessageBlock(block)) {
            space = state.selectorNamespace;
        }
        String name = this.pullNameThrough(state, references[0].getToAddress(), space);
        if (this.isClassBlock(block)) {
            if (state.currentClassName == null) {
                state.currentClassName = name;
            }
        } else if (this.isMessageBlock(block) && state.currentMethodName == null) {
            state.currentMethodName = name;
        }
        return name;
    }

    private boolean isMessageBlock(MemoryBlock block) {
        return block.getName().equals("__message_refs");
    }

    private boolean isClassBlock(MemoryBlock block) {
        return block.getName().equals("__cls_refs") || block.getName().equals("__class");
    }

    private boolean isValidInstruction(Instruction instruction) {
        if (instruction.getNumOperands() != 2) {
            return false;
        }
        boolean isMOV = instruction.getMnemonicString().equals("MOV");
        boolean isLWZ = instruction.getMnemonicString().equals("lwz");
        boolean isLDR = instruction.getMnemonicString().equals("ldr");
        return isMOV || isLWZ || isLDR;
    }

    private class CurrentState {
        Program program;
        Namespace globalNamespace;
        Namespace selectorNamespace;
        Namespace idNamespace;
        String currentClassName = null;
        String currentMethodName = null;

        CurrentState(ObjectiveC1_MessageAnalyzer objectiveC1_MessageAnalyzer, Program program) {
            this.program = program;
            this.globalNamespace = program.getGlobalNamespace();
            SymbolTable symbolTable = program.getSymbolTable();
            this.selectorNamespace = this.findMatchingChildNamespace("@sel", this.globalNamespace, symbolTable);
            this.idNamespace = this.findMatchingChildNamespace("@id", this.globalNamespace, symbolTable);
        }

        boolean isValid() {
            return this.currentMethodName != null && this.currentClassName != null;
        }

        void reset() {
            this.currentClassName = null;
            this.currentMethodName = null;
        }

        public String toString() {
            return "[" + this.currentClassName + " " + this.currentMethodName + "]";
        }

        private Namespace findMatchingChildNamespace(String namespaceName, Namespace parentNamespace, SymbolTable symbolTable) {
            SymbolIterator it = symbolTable.getSymbols(parentNamespace);
            while (it.hasNext()) {
                Symbol s = it.next();
                if (s.getSymbolType() != SymbolType.NAMESPACE || !namespaceName.equals(s.getName())) continue;
                return (Namespace)s.getObject();
            }
            try {
                return symbolTable.createNameSpace(parentNamespace, namespaceName, SourceType.ANALYSIS);
            }
            catch (DuplicateNameException | InvalidInputException e) {
                return null;
            }
        }
    }
}

