/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.MenuData;
import ghidra.app.cmd.function.CreateFunctionDefinitionCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.util.FunctionSignatureFieldLocation;

class CreateFunctionDefinitionAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;

    CreateFunctionDefinitionAction(FunctionPlugin plugin) {
        super("Create Function Definition", plugin.getName());
        this.funcPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Function", "Create Function Definition"}, null, "Function"));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Function function = this.funcPlugin.getFunction(context);
        if (function == null) {
            return;
        }
        Address entry = function.getEntryPoint();
        this.funcPlugin.execute(context.getProgram(), new CreateFunctionDefinitionCmd(entry, (ServiceProvider)this.funcPlugin.getTool()));
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        return context.getLocation() instanceof FunctionSignatureFieldLocation;
    }
}

