/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;

class EditStructureAction
extends ListingContextAction {
    private FunctionPlugin plugin;
    private static final String[] POPUP_PATH = new String[]{"Set Data Type", "Edit Structure..."};

    EditStructureAction(FunctionPlugin plugin) {
        super("Edit Structure", plugin.getName());
        this.setPopupMenuData(new MenuData(POPUP_PATH, null, "Array"));
        this.setHelpLocation(new HelpLocation("DataTypeEditors", "Structure_Editor"));
        this.plugin = plugin;
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        FunctionLocation loc;
        Program program = context.getProgram();
        DataType dt = this.getDataType(program, loc = (FunctionLocation)context.getLocation());
        if (dt instanceof Composite) {
            this.plugin.getDataTypeManagerService().edit(dt);
        }
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation loc = context.getLocation();
        Program program = context.getProgram();
        if (!(loc instanceof VariableLocation) && !(loc instanceof VariableCommentFieldLocation)) {
            return false;
        }
        DataType dt = this.getDataType(program, (FunctionLocation)loc);
        return dt != null && dt instanceof Composite && !(dt instanceof BuiltInDataType);
    }

    private DataType getDataType(Program program, FunctionLocation loc) {
        if (program == null) {
            return null;
        }
        Listing listing = program.getListing();
        Function f = listing.getFunctionAt(loc.getAddress());
        if (f == null) {
            return null;
        }
        DataType dt = null;
        if (loc instanceof FunctionSignatureFieldLocation) {
            dt = f.getReturnType();
        } else {
            Variable var = this.getVariable(f, (ProgramLocation)loc);
            if (var != null) {
                dt = var.getDataType();
            }
        }
        if (dt instanceof Pointer) {
            Pointer pdt = (Pointer)dt;
            dt = pdt.getDataType();
        }
        return dt;
    }

    private Variable getVariable(Function function, ProgramLocation currentLocation) {
        if (function == null) {
            return null;
        }
        if (currentLocation instanceof VariableLocation) {
            return ((VariableLocation)currentLocation).getVariable();
        }
        return null;
    }
}

