/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.DialogComponentProvider;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.table.FocusableEditor;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.MessageType;
import ghidra.util.data.DataTypeParser;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

class ParameterDataTypeCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusableEditor {
    private DataTypeSelectionEditor editor;
    private DropDownSelectionTextField<DataType> textField;
    private DataType dt;
    private DataTypeManagerService service;
    private DialogComponentProvider dialog;
    private DataTypeManager dtm;

    ParameterDataTypeCellEditor(DialogComponentProvider dialog, DataTypeManagerService service, DataTypeManager dtm) {
        this.dialog = dialog;
        this.service = service;
        this.dtm = dtm;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
        this.dt = (DataType)value;
        this.init();
        this.editor.setCellEditorValue(this.dt);
        return this.editor.getEditorComponent();
    }

    private void init() {
        this.editor = new DataTypeSelectionEditor(this.dtm, this.service, DataTypeParser.AllowedDataTypes.ALL);
        this.editor.setTabCommitsEdit(true);
        this.editor.setConsumeEnterKeyPress(false);
        this.textField = this.editor.getDropDownTextField();
        this.editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                ParameterDataTypeCellEditor.this.cancelCellEditing();
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                ParameterDataTypeCellEditor.this.stopCellEditing();
            }
        });
        this.textField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ParameterDataTypeCellEditor.this.textField.selectAll();
                ParameterDataTypeCellEditor.this.textField.removeFocusListener((FocusListener)this);
            }
        });
    }

    public void focusEditor() {
        this.textField.requestFocusInWindow();
    }

    public DropDownSelectionTextField<DataType> getTextField() {
        return this.textField;
    }

    @Override
    public Object getCellEditorValue() {
        return this.dt;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            DataType dataType = this.editor.getCellEditorValueAsDataType();
            this.dialog.clearStatusText();
            if (dataType == null) {
                String text = this.editor.getCellEditorValueAsText();
                this.dialog.setStatusText("Invalid data type: " + text, MessageType.ERROR);
                return false;
            }
            if (dataType.equals((Object)this.dt)) {
                this.fireEditingCanceled();
            } else {
                this.dt = dataType.clone(this.dtm);
                this.fireEditingStopped();
            }
        }
        catch (IllegalArgumentException ex) {
            String text = this.editor.getCellEditorValueAsText();
            this.dialog.setStatusText("Invalid data type: " + text, MessageType.ERROR);
            return false;
        }
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    DataTypeSelectionEditor getEditor() {
        return this.editor;
    }
}

