/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import generic.theme.GIcon;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.help.UnsupportedOperationException;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class NextPreviousInstructionAction
extends AbstractNextPreviousAction {
    private static final Icon ICON = new GIcon("icon.plugin.navigation.instruction");

    public NextPreviousInstructionAction(PluginTool tool, String owner, String subGroup) {
        super(tool, "Next Instruction", owner, subGroup);
    }

    @Override
    protected Icon getIcon() {
        return ICON;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(73, 640);
    }

    @Override
    protected String getNavigationTypeName() {
        return "Instruction";
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, NavigatableActionContext context) throws CancelledException {
        Program program = context.getProgram();
        Address address = context.getAddress();
        if (this.isInverted) {
            return this.getNextNonInstructionAddress(monitor, program, address);
        }
        if (this.useCurrentInstruction(context)) {
            return address;
        }
        if (this.isInstructionAt(program, address)) {
            address = this.getAddressOfNextPreviousNonInstruction(monitor, program, address, true);
        }
        return this.getAddressOfNextInstructionAfter(program, address);
    }

    private boolean useCurrentInstruction(NavigatableActionContext context) {
        ProgramLocation location = context.getLocation();
        return !(location instanceof AddressFieldLocation);
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, NavigatableActionContext context) throws CancelledException {
        Program program = context.getProgram();
        Address address = context.getAddress();
        if (this.isInverted) {
            return this.getPreviousNonInstructionAddress(monitor, program, address);
        }
        if (this.isInstructionAt(program, address)) {
            address = this.getAddressOfNextPreviousNonInstruction(monitor, program, address, false);
        }
        return this.getAddressOfPreviousInstructionBefore(program, address);
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        throw new UnsupportedOperationException();
    }

    private Address getNextNonInstructionAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (!this.isInstructionAt(program, address)) {
            address = this.getAddressOfNextInstructionAfter(program, address);
        }
        return this.getAddressOfNextPreviousNonInstruction(monitor, program, address, true);
    }

    private Address getPreviousNonInstructionAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (!this.isInstructionAt(program, address)) {
            address = this.getAddressOfPreviousInstructionBefore(program, address);
        }
        return this.getAddressOfNextPreviousNonInstruction(monitor, program, address, false);
    }

    private boolean isInstructionAt(Program program, Address address) {
        if (address == null) {
            return false;
        }
        return program.getListing().getInstructionAt(address) != null;
    }

    private Address getAddressOfNextInstructionAfter(Program program, Address address) {
        if (address == null) {
            return null;
        }
        Instruction instruction = program.getListing().getInstructionAfter(address);
        if (instruction == null) {
            return null;
        }
        return instruction.getMinAddress();
    }

    private Address getAddressOfPreviousInstructionBefore(Program program, Address address) {
        if (address == null) {
            return null;
        }
        Instruction instruction = program.getListing().getInstructionBefore(address);
        if (instruction == null) {
            return null;
        }
        return instruction.getMinAddress();
    }

    private Address getAddressOfNextPreviousNonInstruction(TaskMonitor monitor, Program program, Address address, boolean forward) throws CancelledException {
        if (address == null) {
            return null;
        }
        CodeUnitIterator codeUnits = program.getListing().getCodeUnits(address, forward);
        while (codeUnits.hasNext()) {
            monitor.checkCancelled();
            CodeUnit codeUnit = codeUnits.next();
            if (!(codeUnit instanceof Data)) continue;
            return codeUnit.getAddress();
        }
        return null;
    }
}

