/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.ComponentProvider;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.symboltree.DisconnectedSymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.SymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.SymbolTreeService;
import ghidra.app.services.GoToService;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.bean.opteditor.OptionsVetoException;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Symbol Tree", description="This plugin shows the symbols from the program in a tree hierarchy.  All symbols (except for the global namespace symbol) have a parent symbol.  From the tree, symbols can be renamed, deleted, or reorganized.", eventsConsumed={ProgramActivatedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramClosedPluginEvent.class}, servicesProvided={SymbolTreeService.class})
public class SymbolTreePlugin
extends Plugin
implements SymbolTreeService {
    private static final String OPTIONS_CATEGORY = "Symbol Tree";
    private static final String OPTION_NAME_GROUP_THRESHOLD = "Group Threshold";
    private SymbolTreeProvider connectedProvider;
    private List<SymbolTreeProvider> disconnectedProviders = new ArrayList<SymbolTreeProvider>();
    private Program program;
    private GoToService goToService;
    private boolean processingGoTo;
    private OptionsChangeListener optionsListener = new SymbolTreeOptionsListener();
    private int nodeGroupThreshold = 200;

    public SymbolTreePlugin(PluginTool tool) {
        super(tool);
        this.connectedProvider = new SymbolTreeProvider(tool, this);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program oldProgram = this.program;
            this.program = ev.getActiveProgram();
            if (oldProgram != null) {
                this.connectedProvider.programDeactivated(oldProgram);
            }
            this.connectedProvider.setProgram(this.program);
        } else if (event instanceof ProgramClosedPluginEvent) {
            this.programClosed(((ProgramClosedPluginEvent)event).getProgram());
        } else if (event instanceof ProgramLocationPluginEvent) {
            if (this.processingGoTo) {
                return;
            }
            ProgramLocation loc = ((ProgramLocationPluginEvent)event).getLocation();
            this.connectedProvider.locationChanged(loc);
            for (SymbolTreeProvider provider : this.disconnectedProviders) {
                provider.locationChanged(loc);
            }
        }
    }

    private void programClosed(Program p) {
        this.connectedProvider.programClosed(p);
        ArrayList<SymbolTreeProvider> copy = new ArrayList<SymbolTreeProvider>(this.disconnectedProviders);
        for (SymbolTreeProvider provider : copy) {
            if (provider.getProgram() != p) continue;
            this.closeDisconnectedProvider(provider);
        }
    }

    void closeDisconnectedProvider(SymbolTreeProvider provider) {
        this.disconnectedProviders.remove((Object)provider);
        this.tool.removeComponentProvider((ComponentProvider)provider);
        provider.dispose();
    }

    protected void init() {
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
        this.initializeOptions();
    }

    private void initializeOptions() {
        ToolOptions options = this.tool.getOptions(OPTIONS_CATEGORY);
        options.addOptionsChangeListener(this.optionsListener);
        HelpLocation help = new HelpLocation("SymbolTreePlugin", "GroupNode");
        options.registerOption(OPTION_NAME_GROUP_THRESHOLD, (Object)this.nodeGroupThreshold, help, "The max number of children before nodes are organized by name");
        this.nodeGroupThreshold = options.getInt(OPTION_NAME_GROUP_THRESHOLD, this.nodeGroupThreshold);
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.connectedProvider);
        this.connectedProvider.dispose();
        this.program = null;
        ArrayList<SymbolTreeProvider> copy = new ArrayList<SymbolTreeProvider>(this.disconnectedProviders);
        for (SymbolTreeProvider provider : copy) {
            this.closeDisconnectedProvider(provider);
        }
    }

    public void readConfigState(SaveState saveState) {
        this.connectedProvider.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.connectedProvider.writeConfigState(saveState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goTo(Symbol symbol) {
        SymbolType type = symbol.getSymbolType();
        if (type.isNamespace() && type != SymbolType.FUNCTION) {
            this.tool.setStatusInfo("Can not navigate to " + (symbol.isExternal() ? "external " : "") + type.toString() + " symbol: " + symbol.getName());
            return;
        }
        boolean success = false;
        String reason = "";
        if (this.goToService != null) {
            this.processingGoTo = true;
            try {
                ProgramLocation loc = symbol.getProgramLocation();
                if (symbol.getAddress().isExternalAddress()) {
                    this.goToService.goTo(symbol.getAddress(), this.program);
                    return;
                }
                if (loc != null) {
                    reason = " (not in-memory)";
                    success = this.goToService.goTo(loc);
                }
            }
            finally {
                this.processingGoTo = false;
            }
        }
        if (!success) {
            this.tool.setStatusInfo("Can not navigate to " + (symbol.isExternal() ? "external " : "") + type.toString() + " symbol: " + symbol.getName() + reason);
        }
    }

    public void goTo(ExternalLocation extLoc) {
        this.goToService.goToExternalLocation(extLoc, false);
    }

    public Program getProgram() {
        return this.program;
    }

    SymbolTreeProvider getProvider() {
        return this.connectedProvider;
    }

    public DisconnectedSymbolTreeProvider createNewDisconnectedProvider(Program p) {
        DisconnectedSymbolTreeProvider newProvider = new DisconnectedSymbolTreeProvider(this.tool, this, p);
        this.disconnectedProviders.add(newProvider);
        this.tool.showComponentProvider((ComponentProvider)newProvider, true);
        return newProvider;
    }

    @Override
    public void selectSymbol(Symbol symbol) {
        this.connectedProvider.selectSymbol(symbol);
    }

    void setNodeGroupThreshold(int threshold) {
        this.nodeGroupThreshold = threshold;
    }

    int getNodeGroupThreshold() {
        return this.nodeGroupThreshold;
    }

    private class SymbolTreeOptionsListener
    implements OptionsChangeListener {
        private SymbolTreeOptionsListener() {
        }

        public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
            if (SymbolTreePlugin.OPTION_NAME_GROUP_THRESHOLD.equals(optionName)) {
                SymbolTreePlugin.this.nodeGroupThreshold = (Integer)newValue;
                SymbolTreePlugin.this.connectedProvider.rebuildTree();
                for (SymbolTreeProvider provider : SymbolTreePlugin.this.disconnectedProviders) {
                    provider.rebuildTree();
                }
            }
        }
    }
}

