/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import ghidra.app.plugin.core.symtable.AbstractSymbolTableModel;
import ghidra.app.plugin.core.symtable.SymbolRowObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

class SymbolTableModel
extends AbstractSymbolTableModel {
    SymbolTableModel(PluginTool tool) {
        super(tool);
    }

    protected void doLoad(Accumulator<SymbolRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.symbolTable == null) {
            return;
        }
        SymbolIterator it = this.symbolTable.getDefinedSymbols();
        monitor.initialize((long)this.getKeyCount());
        int value = 0;
        while (it.hasNext()) {
            monitor.setProgress((long)value++);
            monitor.checkCancelled();
            Symbol s = it.next();
            if (!this.filter.accepts(s, this.getProgram())) continue;
            accumulator.add((Object)new SymbolRowObject(s));
        }
        if (this.filter.acceptsDefaultLabelSymbols()) {
            AddressIterator addrIt = this.refMgr.getReferenceDestinationIterator((AddressSetView)this.getProgram().getAddressFactory().getAddressSet(), true);
            while (addrIt.hasNext()) {
                monitor.setProgress((long)value++);
                monitor.checkCancelled();
                Address a = addrIt.next();
                Symbol s = this.symbolTable.getPrimarySymbol(a);
                if (!s.isDynamic() || !this.filter.accepts(s, this.getProgram())) continue;
                accumulator.add((Object)new SymbolRowObject(s));
            }
        }
    }
}

