/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;

public class MemoryByteProvider
implements ByteProvider {
    protected Memory memory;
    protected Address baseAddress;
    protected long maxOffset;
    protected boolean isEmtpy;

    public static MemoryByteProvider createMemoryBlockByteProvider(Memory memory, MemoryBlock block) {
        return new MemoryByteProvider(memory, block.getStart(), block.getEnd());
    }

    public static MemoryByteProvider createProgramHeaderByteProvider(Program program, boolean firstBlockOnly) {
        return new MemoryByteProvider(program.getMemory(), program.getMinAddress(), firstBlockOnly);
    }

    public static MemoryByteProvider createDefaultAddressSpaceByteProvider(Program program, boolean firstBlockOnly) {
        return new MemoryByteProvider(program.getMemory(), program.getAddressFactory().getDefaultAddressSpace().getMinAddress(), firstBlockOnly);
    }

    public MemoryByteProvider(Memory memory, AddressSpace space) {
        this(memory, space.getMinAddress());
    }

    public MemoryByteProvider(Memory memory, Address baseAddress) {
        this(memory, baseAddress, false);
    }

    public MemoryByteProvider(Memory memory, Address baseAddress, boolean firstBlockOnly) {
        this(memory, baseAddress, firstBlockOnly ? MemoryByteProvider.findEndOfBlock(memory, baseAddress) : MemoryByteProvider.findAddressSpaceMax(memory, baseAddress));
    }

    public MemoryByteProvider(Memory memory, Address baseAddress, Address maxAddress) {
        this.memory = memory;
        this.baseAddress = baseAddress;
        this.maxOffset = maxAddress != null ? maxAddress.subtract(baseAddress) : 0L;
        this.isEmtpy = maxAddress == null;
    }

    public Memory getMemory() {
        return this.memory;
    }

    private Address getAddress(long index) throws IOException {
        long newAddress;
        if (index == 0L) {
            return this.baseAddress;
        }
        long base = this.baseAddress.getOffset();
        if (Long.compareUnsigned(base, newAddress = base + index) > 0) {
            throw new IOException("Invalid index: %s".formatted(Long.toUnsignedString(index)));
        }
        return this.baseAddress.getNewAddress(newAddress);
    }

    public Address getStartAddress() {
        return this.baseAddress;
    }

    public Address getEndAddress() {
        return this.baseAddress.getNewAddress(this.baseAddress.getOffset() + this.maxOffset);
    }

    public AddressSetView getAddressSet() {
        return new AddressSet(this.baseAddress, this.getEndAddress());
    }

    @Override
    public boolean isEmpty() {
        return this.isEmtpy;
    }

    @Override
    public File getFile() {
        return new File(this.memory.getProgram().getExecutablePath());
    }

    @Override
    public String getName() {
        return this.memory.getProgram().getName();
    }

    @Override
    public String getAbsolutePath() {
        return this.memory.getProgram().getExecutablePath();
    }

    @Override
    public long length() throws IOException {
        if (this.isEmtpy) {
            return 0L;
        }
        return Long.compareUnsigned(this.maxOffset, 0x7FFFFFFFFFFFFFFEL) >= 0 ? Long.MAX_VALUE : this.maxOffset + 1L;
    }

    @Override
    public boolean isValidIndex(long index) {
        try {
            if (this.isEmtpy || Long.compareUnsigned(index, this.maxOffset) > 0) {
                return false;
            }
            return this.memory.contains(this.getAddress(index));
        }
        catch (AddressOutOfBoundsException | IOException e) {
            return false;
        }
    }

    @Override
    public byte readByte(long index) throws IOException {
        this.ensureBounds(index, 1L);
        try {
            return this.memory.getByte(this.getAddress(index));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        this.ensureBounds(index, length);
        try {
            byte[] bytes = new byte[(int)length];
            int nRead = this.memory.getBytes(this.getAddress(index), bytes);
            if ((long)nRead != length) {
                throw new IOException("Unable to read %d bytes at index %s".formatted(length, Long.toUnsignedString(index)));
            }
            return bytes;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() {
    }

    private void ensureBounds(long index, long length) throws IOException {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IOException("Unable to read more than Integer.MAX_VALUE bytes in one operation: %s".formatted(Long.toUnsignedString(length)));
        }
        if (index == 0L && length == 0L) {
            return;
        }
        if (this.isEmtpy || Long.compareUnsigned(index, this.maxOffset) > 0) {
            throw new EOFException("Invalid index: %s".formatted(Long.toUnsignedString(index)));
        }
        long remaining = this.maxOffset - index;
        if (length != 0L && Long.compareUnsigned(length - 1L, remaining) > 0) {
            throw new EOFException("Unable to read past EOF: %s, %d".formatted(Long.toUnsignedString(index), length));
        }
    }

    private static Address findEndOfBlock(Memory memory, Address minAddr) {
        MemoryBlock block = memory.getBlock(minAddr);
        if (block != null) {
            return block.getEnd();
        }
        AddressSpace space = minAddr.getAddressSpace();
        for (MemoryBlock block2 : memory.getBlocks()) {
            Address end = block2.getEnd();
            if (!end.getAddressSpace().equals((Object)space) || end.compareTo((Object)minAddr) < 0) continue;
            return end;
        }
        return null;
    }

    private static Address findAddressSpaceMax(Memory memory, Address minAddr) {
        if (minAddr == null) {
            return null;
        }
        AddressSpace space = minAddr.getAddressSpace();
        Address maxAddr = null;
        for (AddressRange range : memory.getAddressRanges()) {
            Address rangeEnd;
            if (!range.getAddressSpace().equals((Object)space) || (rangeEnd = range.getMaxAddress()).compareTo((Object)minAddr) < 0 || maxAddr != null && rangeEnd.compareTo((Object)maxAddr) < 0) continue;
            maxAddr = rangeEnd;
        }
        return maxAddr;
    }
}

