/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFSourceLanguage;
import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpression;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DWARFImportSummary {
    long dataTypeElapsedMS;
    long funcsElapsedMS;
    long macroElapsedMS;
    long totalElapsedMS;
    int dataTypesAdded;
    int funcsAdded;
    int funcsUpdated;
    int funcSignaturesAdded;
    int globalVarsAdded;
    Set<String> relocationErrorVarDefs = new HashSet<String>();
    int exprReadError;
    Set<String> typeRemappings = new HashSet<String>();
    int paramZeroLenDataType;
    public int badSourceFileCount;
    public int numEnumsCreated;
    Set<Integer> dwarfVers = new HashSet<Integer>();
    int compUnitCount;
    int dieCount;
    Set<String> compDirs = new HashSet<String>();
    List<String> compNames = new ArrayList<String>();
    Set<String> producers = new HashSet<String>();
    Set<String> sourceLangs = new HashSet<String>();
    Map<DWARFExpression, Integer> failedExpressions = new HashMap<DWARFExpression, Integer>();

    public void logSummaryResults() {
        if (this.totalElapsedMS > 0L) {
            Msg.info((Object)this, (Object)"DWARF ver%s, %d compUnits, %d DIES, import - total elapsed: %dms".formatted(this.getSortedSet(this.dwarfVers).toString(), this.compUnitCount, this.dieCount, this.totalElapsedMS));
        }
        if (this.dataTypeElapsedMS > 0L) {
            Msg.info((Object)this, (Object)String.format("DWARF data type import - elapsed: %dms", this.dataTypeElapsedMS));
        }
        if (this.funcsElapsedMS > 0L) {
            Msg.info((Object)this, (Object)String.format("DWARF func & symbol import - elapsed: %dms", this.funcsElapsedMS));
        }
        if (this.dataTypesAdded > 0) {
            Msg.info((Object)this, (Object)String.format("DWARF types imported: %d", this.dataTypesAdded));
        }
        if (this.funcsAdded > 0) {
            Msg.info((Object)this, (Object)String.format("DWARF funcs added: %d", this.funcsAdded));
        }
        if (this.funcSignaturesAdded > 0) {
            Msg.info((Object)this, (Object)String.format("DWARF function signatures added: %d", this.funcSignaturesAdded));
        }
        if (this.numEnumsCreated > 0) {
            Msg.info((Object)this, (Object)"DWARF enums created from macro info entries: %d".formatted(this.numEnumsCreated));
        }
        if (this.macroElapsedMS > 0L) {
            Msg.info((Object)this, (Object)"DWARF enums from macros - elapsed: %dms".formatted(this.macroElapsedMS));
        }
        if (!this.compDirs.isEmpty()) {
            Msg.info((Object)this, (Object)("DWARF compile dirs: " + this.getSortedSet(this.compDirs).toString()));
        }
        if (!this.producers.isEmpty()) {
            Msg.info((Object)this, (Object)("DWARF producers: " + String.valueOf(this.getSortedSet(this.producers))));
        }
        if (!this.sourceLangs.isEmpty()) {
            Msg.info((Object)this, (Object)("DWARF source languages: " + String.valueOf(this.getSortedSet(this.sourceLangs))));
        }
        for (String string : this.compNames) {
            Msg.info((Object)this, (Object)("DWARF compUnit: " + string));
        }
        if (!this.typeRemappings.isEmpty()) {
            Msg.error((Object)this, (Object)"DWARF data type remappings (DWARF data type definitions that changed meaning in different compile units):");
            Msg.error((Object)this, (Object)"  Data type -> changed to -> Data Type");
            int x = 0;
            for (String s : this.typeRemappings) {
                Msg.error((Object)this, (Object)("  " + s));
                if (x++ <= 1000) continue;
                Msg.error((Object)this, (Object)("...omitting " + (this.typeRemappings.size() - 1000) + " additional type remapping warnings."));
                break;
            }
        }
        if (!this.relocationErrorVarDefs.isEmpty()) {
            Msg.error((Object)this, (Object)"DWARF static variables with missing address info:");
            Msg.error((Object)this, (Object)"  [Variable symbolic name  : variable data type]");
            for (String string : this.relocationErrorVarDefs) {
                Msg.error((Object)this, (Object)("  " + string));
            }
        }
        if (!this.failedExpressions.isEmpty()) {
            Msg.error((Object)this, (Object)"DWARF un-recoverable expressions:");
            for (Map.Entry entry : this.failedExpressions.entrySet()) {
                Msg.error((Object)this, (Object)"  %s -> %d".formatted(entry.getKey(), entry.getValue()));
            }
        }
        if (this.paramZeroLenDataType > 0) {
            Msg.error((Object)this, (Object)("DWARF zero-length parameters: " + this.paramZeroLenDataType));
        }
        if (this.exprReadError > 0) {
            Msg.error((Object)this, (Object)("DWARF expression failed to read: " + this.exprReadError));
        }
        if (this.badSourceFileCount > 0) {
            Msg.error((Object)this, (Object)"DWARF source file info errors: %d".formatted(this.badSourceFileCount));
        }
    }

    private <T extends Comparable<T>> List<T> getSortedSet(Set<T> set) {
        ArrayList<T> result = new ArrayList<T>(set);
        Collections.sort(result);
        return result;
    }

    void addCompunitInfo(List<DWARFCompilationUnit> compUnits) {
        for (DWARFCompilationUnit cu : compUnits) {
            int lang;
            String prod;
            String name;
            String compileDirectory = cu.getCompileDirectory();
            if (compileDirectory != null && !compileDirectory.isBlank()) {
                this.compDirs.add(compileDirectory);
            }
            if ((name = cu.getName()) != null && !name.isBlank()) {
                this.compNames.add(name);
            }
            if ((prod = cu.getProducer()) != null && !prod.isBlank()) {
                this.producers.add(prod);
            }
            if ((lang = cu.getLanguage()) == -1) continue;
            this.sourceLangs.add(DWARFUtil.toString(DWARFSourceLanguage.class, lang));
        }
    }

    void addProblematicDWARFExpression(DWARFExpression expr) {
        if (expr != null) {
            expr = expr.toGenericForm();
            this.failedExpressions.compute(expr, (prevexpr, count) -> count != null ? count + 1 : 1);
        }
    }
}

