/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.macro;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import ghidra.app.util.bin.format.dwarf.line.DWARFLine;
import ghidra.app.util.bin.format.dwarf.macro.DWARFMacroOpcode;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroInfoEntry;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWARFMacroHeader {
    private static final int OFFSET_SIZE_FLAG_MASK = 1;
    private static final int DEBUG_LINE_OFFSET_FLAG_MASK = 2;
    private static final int OPCODE_OPERANDS_TABLE_FLAG_MASK = 4;
    private long startOffset;
    private int version;
    private int flags;
    private long debug_line_offset;
    private int intSize;
    private long entriesStartOffset;
    private Map<Integer, List<DWARFForm>> opcodeMap;
    private DWARFCompilationUnit cu;
    private DWARFLine line;
    public static final DWARFMacroHeader EMTPY = new DWARFMacroHeader(0L, 0, 0, 0L, 0, 0L, null, DWARFLine.empty(), null){

        @Override
        public List<DWARFMacroInfoEntry> getEntries() throws IOException {
            return List.of();
        }
    };

    public static DWARFMacroHeader readV5(BinaryReader reader, DWARFCompilationUnit cu) throws IOException {
        long startOffset = reader.getPointerIndex();
        int version = reader.readNextUnsignedShort();
        if (version != 5) {
            throw new IllegalArgumentException("Unsupported DWARF Macro version: " + version);
        }
        int flags = reader.readNextUnsignedByte();
        int intSize = (flags & 1) == 1 ? 8 : 4;
        DWARFLine line = null;
        long debug_line_offset = -1L;
        if ((flags & 2) != 0) {
            debug_line_offset = reader.readNextUnsignedValue(intSize);
            line = cu.getProgram().getLine(debug_line_offset, cu, false);
        }
        Map<Integer, List<DWARFForm>> opcodeMap = DWARFMacroOpcode.defaultOpcodeOperandMap;
        if ((flags & 4) != 0) {
            opcodeMap = new HashMap<Integer, List<DWARFForm>>(opcodeMap);
            DWARFMacroHeader.readMacroOpcodeTable(reader, opcodeMap);
        }
        return new DWARFMacroHeader(startOffset, version, flags, debug_line_offset, intSize, reader.getPointerIndex(), cu, line, opcodeMap);
    }

    private static void readMacroOpcodeTable(BinaryReader reader, Map<Integer, List<DWARFForm>> opcodeMap) throws IOException {
        int numOpcodes = reader.readNextUnsignedByte();
        for (int i = 0; i < numOpcodes; ++i) {
            int opcode = reader.readNextUnsignedByte();
            int numOperands = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
            DWARFForm[] operandForms = new DWARFForm[numOperands];
            for (int formIndex = 0; formIndex < numOperands; ++formIndex) {
                int formInt = reader.readNextUnsignedByte();
                operandForms[formIndex] = DWARFForm.of(formInt);
            }
            opcodeMap.put(opcode, List.of(operandForms));
        }
    }

    public static List<DWARFMacroInfoEntry> readMacroEntries(BinaryReader reader, DWARFMacroHeader macroHeader) throws IOException {
        DWARFMacroInfoEntry entry;
        ArrayList<DWARFMacroInfoEntry> results = new ArrayList<DWARFMacroInfoEntry>();
        while ((entry = DWARFMacroInfoEntry.read(reader, macroHeader)) != null) {
            results.add(entry);
        }
        return results;
    }

    public DWARFMacroHeader(long startOffset, int version, int flags, long debug_line_offset, int intSize, long entriesStartOffset, DWARFCompilationUnit cu, DWARFLine line, Map<Integer, List<DWARFForm>> opcodeMap) {
        this.startOffset = startOffset;
        this.version = version;
        this.flags = flags;
        this.debug_line_offset = debug_line_offset;
        this.intSize = intSize;
        this.entriesStartOffset = entriesStartOffset;
        this.cu = cu;
        this.line = line;
        this.opcodeMap = opcodeMap;
    }

    public DWARFLine getLine() {
        return this.line;
    }

    public long getDebug_line_offset() {
        return this.debug_line_offset;
    }

    public int getIntSize() {
        return this.intSize;
    }

    public long getEntriesStartOffset() {
        return this.entriesStartOffset;
    }

    public List<DWARFMacroInfoEntry> getEntries() throws IOException {
        return this.cu.getProgram().getMacroEntries(this);
    }

    public DWARFCompilationUnit getCompilationUnit() {
        return this.cu;
    }

    public Map<Integer, List<DWARFForm>> getOpcodeMap() {
        return this.opcodeMap;
    }

    public String toString() {
        return "DWARFMacroHeader: startOffset=0x%x, debug_line_offset=0x%x, intSize=%d".formatted(this.startOffset, this.debug_line_offset, this.intSize);
    }
}

