/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.GoVerRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public record GoVerSet(List<GoVerRange> ranges) {
    public static final GoVerSet ALL = new GoVerSet(List.of(GoVerRange.ALL));

    public static GoVerSet parse(String s) throws IOException {
        if (s.trim().equalsIgnoreCase("all")) {
            return ALL;
        }
        ArrayList<GoVerRange> result = new ArrayList<GoVerRange>();
        for (String verStr : s.split(",")) {
            GoVerRange prev;
            GoVerRange range;
            if ((verStr = verStr.trim()).isEmpty() || (range = GoVerRange.parse(verStr)).isEmpty()) continue;
            if (range.start().isWildcard() && !result.isEmpty()) {
                throw new IOException("Invalid start wildcard position: [%s]".formatted(s));
            }
            GoVerRange goVerRange = prev = !result.isEmpty() ? (GoVerRange)result.get(result.size() - 1) : null;
            if (prev != null && prev.end().isWildcard()) {
                throw new IOException("Invalid end wildcard position: [%s]".formatted(s));
            }
            result.add(range);
        }
        return new GoVerSet(List.copyOf(result));
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public boolean contains(GoVer ver) {
        for (GoVerRange range : this.ranges) {
            if (!range.contains(ver)) continue;
            return true;
        }
        return false;
    }
}

