/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.AbstractOmfRecordFactory;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.omf.OmfFileHeader;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;

public class OmfLibraryRecord {
    private int recordType;
    private int recordLength;
    private int pageSize;
    private long dictionaryOffset;
    private int dictionarySize;
    private byte flags;
    private ArrayList<MemberHeader> members;

    public OmfLibraryRecord(BinaryReader reader) throws IOException, OmfException {
        this.recordType = reader.readNextUnsignedByte();
        this.recordLength = reader.readNextUnsignedShort();
        this.pageSize = this.recordLength + 3;
        this.dictionaryOffset = reader.readNextInt() & 0xFFFFFFFF;
        this.dictionarySize = reader.readNextShort() & 0xFFFF;
        this.flags = reader.readNextByte();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public ArrayList<MemberHeader> getMemberHeaders() {
        return this.members;
    }

    public static boolean checkMagicNumber(BinaryReader reader) throws IOException {
        byte type = reader.readNextByte();
        if (type != -16) {
            return false;
        }
        int pageSize = (reader.readNextShort() & 0xFFFF) + 3;
        int count = 0;
        int mask = pageSize;
        while ((mask & 1) == 0) {
            ++count;
            mask >>>= 1;
        }
        if (mask != 1) {
            return false;
        }
        if (count < 4) {
            return false;
        }
        if (count > 15) {
            return false;
        }
        reader.align(pageSize);
        type = reader.readNextByte();
        return (type & 0xFC) == 128;
    }

    public static OmfLibraryRecord parse(AbstractOmfRecordFactory factory, TaskMonitor monitor) throws IOException, OmfException {
        OmfLibraryRecord res = null;
        BinaryReader reader = factory.getReader();
        byte type = reader.peekNextByte();
        if (type != -16) {
            throw new IOException("Not an OMF Library record");
        }
        res = new OmfLibraryRecord(reader);
        res.members = new ArrayList();
        reader.align(res.pageSize);
        type = reader.peekNextByte();
        while (type != -15) {
            OmfFileHeader fileheader;
            MemberHeader curheader = new MemberHeader();
            curheader.payloadOffset = reader.getPointerIndex();
            try {
                fileheader = OmfFileHeader.scan(factory, monitor, false);
            }
            catch (OmfException e) {
                throw new IOException("Could not parse individual object file within archive");
            }
            curheader.name = fileheader.getLibraryModuleName();
            if (curheader.name == null) {
                curheader.name = fileheader.getName();
            }
            curheader.machineName = fileheader.getMachineName();
            curheader.translator = fileheader.getTranslator();
            curheader.size = (int)(reader.getPointerIndex() - curheader.payloadOffset);
            res.members.add(curheader);
            reader.align(res.pageSize);
            type = reader.peekNextByte();
        }
        return res;
    }

    public static class MemberHeader {
        public long payloadOffset;
        public long size;
        public String name;
        public String translator;
        public String machineName;
    }
}

