/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.som.SomAuxHeader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomProductSpecificsAuxHeader
extends SomAuxHeader {
    private byte[] bytes;

    public SomProductSpecificsAuxHeader(BinaryReader reader) throws IOException {
        super(reader);
        this.bytes = reader.readNextByteArray((int)this.auxId.getLength());
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("som_product_specifics_auxhdr", 0);
        struct.setPackingEnabled(true);
        struct.add(this.auxId.toDataType(), "som_auxhdr", null);
        struct.add((DataType)new ArrayDataType(BYTE, (int)this.auxId.getLength(), 1), "bytes", null);
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

