/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;

public class HTMLResourceDataType
extends BuiltIn
implements Dynamic {
    public HTMLResourceDataType() {
        this(null);
    }

    public HTMLResourceDataType(DataTypeManager dtm) {
        super(null, "HTML-Resource", dtm);
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new HTMLResourceDataType(dtm);
    }

    public String getMnemonic(Settings settings) {
        return "HTML";
    }

    public int getLength() {
        return -1;
    }

    public int getLength(MemBuffer buf, int maxLength) {
        if (buf != null && maxLength < 0) {
            return maxLength;
        }
        return maxLength;
    }

    public String getDescription() {
        return "HTML Resource stored within program";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        byte[] data = new byte[length];
        if (buf.getBytes(data, 0) != length) {
            Msg.error((Object)((Object)this), (Object)"HTML Resource error: Not enough bytes in memory");
            return null;
        }
        String htmlString = new String(data);
        String rawMessage = HTMLUtilities.fromHTML((String)htmlString);
        return rawMessage;
    }

    public Class<?> getValueClass(Settings settings) {
        return String.class;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (length <= 0) {
            return "??";
        }
        String htmlString = (String)this.getValue(buf, settings, length);
        if (htmlString == null) {
            return "<HTML-Resource>";
        }
        String rawMessage = HTMLUtilities.fromHTML((String)htmlString);
        rawMessage = rawMessage.replaceAll("\u0000", "");
        return rawMessage;
    }

    public boolean canSpecifyLength() {
        return true;
    }

    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }
}

