/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.util.List;

public abstract class AbstractProgramWrapperLoader
extends AbstractProgramLoader {
    protected abstract void load(Program var1, Loader.ImporterSettings var2) throws CancelledException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Loaded<Program>> loadProgram(Loader.ImporterSettings settings) throws IOException, CancelledException {
        Program program = this.createProgram(settings);
        Loaded<Program> loaded = new Loaded<Program>(program, settings);
        int transactionID = program.startTransaction("Loading");
        boolean success = false;
        try {
            this.load(program, settings);
            this.createDefaultMemoryBlocks(program, settings);
            success = true;
            List<Loaded<Program>> list = List.of(loaded);
            return list;
        }
        finally {
            program.endTransaction(transactionID, true);
            if (!success) {
                loaded.close();
            }
        }
    }

    @Override
    protected void loadProgramInto(Program program, Loader.ImporterSettings settings) throws CancelledException, LoadException, IOException {
        LanguageCompilerSpecPair pair = settings.loadSpec().getLanguageCompilerSpec();
        LanguageID languageID = program.getLanguageID();
        CompilerSpecID compilerSpecID = program.getCompilerSpec().getCompilerSpecID();
        if (!pair.languageID.equals((Object)languageID) || !pair.compilerSpecID.equals((Object)compilerSpecID)) {
            String message = settings.provider().getAbsolutePath() + " does not have the same language/compiler spec as program " + program.getName();
            settings.log().appendMsg(message);
            throw new LoadException(message);
        }
        this.load(program, settings);
    }

    @Override
    public LoaderTier getTier() {
        return LoaderTier.GENERIC_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }
}

