/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.HexLong;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BinaryLoader
extends AbstractProgramLoader {
    public static final String BINARY_NAME = "Raw Binary";
    public static final String OPTION_NAME_LEN = "Length";
    public static final String OPTION_NAME_FILE_OFFSET = "File Offset";
    public static final String OPTION_NAME_BASE_ADDR = "Base Address";
    public static final String OPTION_NAME_BLOCK_NAME = "Block Name";
    public static final String OPTION_NAME_IS_OVERLAY = "Overlay";

    @Override
    public LoaderTier getTier() {
        return LoaderTier.UNTARGETED_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 100;
    }

    @Override
    public boolean supportsLoadIntoProgram() {
        return true;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        List languageDescriptions = this.getLanguageService().getLanguageDescriptions(false);
        for (LanguageDescription languageDescription : languageDescriptions) {
            Collection compilerSpecDescriptions = languageDescription.getCompatibleCompilerSpecDescriptions();
            for (CompilerSpecDescription compilerSpecDescription : compilerSpecDescriptions) {
                LanguageCompilerSpecPair lcs = new LanguageCompilerSpecPair(languageDescription.getLanguageID(), compilerSpecDescription.getCompilerSpecID());
                loadSpecs.add(new LoadSpec(this, 0L, lcs, false));
            }
        }
        return loadSpecs;
    }

    private static Long parseLong(Option option) {
        Object value = option.getValue();
        if (value == null) {
            return null;
        }
        String rendered = value.toString();
        if (rendered.toLowerCase().startsWith("0x")) {
            rendered = rendered.substring(2);
        }
        return NumericUtilities.parseHexLong((String)rendered);
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        String optName;
        long origFileLength;
        Address baseAddr = null;
        long length = 0L;
        long fileOffset = 0L;
        boolean isOverlay = false;
        try {
            origFileLength = provider.length();
        }
        catch (IOException e) {
            return "Error determining length: " + e.getMessage();
        }
        for (Option option : options) {
            optName = option.getName();
            try {
                if (!optName.equals(OPTION_NAME_BASE_ADDR)) continue;
                baseAddr = (Address)option.getValue();
            }
            catch (Exception e) {
                if (e instanceof OptionException) {
                    return e.getMessage();
                }
                return "Invalid value for " + optName + " - " + String.valueOf(option.getValue());
            }
        }
        if (baseAddr == null) {
            return "Invalid base address";
        }
        for (Option option : options) {
            optName = option.getName();
            try {
                if (optName.equals(OPTION_NAME_BASE_ADDR)) continue;
                if (optName.equals(OPTION_NAME_FILE_OFFSET)) {
                    try {
                        fileOffset = BinaryLoader.parseLong(option);
                    }
                    catch (Exception e) {
                        fileOffset = -1L;
                    }
                    if (fileOffset >= 0L && fileOffset < origFileLength) continue;
                    return "File Offset must be greater than or equal to 0 and less than file length " + origFileLength + " (0x" + Long.toHexString(origFileLength) + ")";
                }
                if (optName.equals(OPTION_NAME_LEN)) {
                    try {
                        length = BinaryLoader.parseLong(option);
                    }
                    catch (Exception e) {
                        length = -1L;
                    }
                    if (length < 0L || length > origFileLength) {
                        return "Length must be greater than or equal to 0 and less than or equal to file length " + origFileLength + " (0x" + Long.toHexString(origFileLength) + ")";
                    }
                    long baseOffset = baseAddr.getOffset();
                    AddressSpace space = baseAddr.getAddressSpace();
                    long maxLength = 0x400000000L;
                    if (space.getSize() < 64) {
                        maxLength = Math.min(maxLength, space.getMaxAddress().getOffset() + 1L - baseOffset);
                    } else if (baseOffset < 0L && baseOffset > -17179869184L) {
                        maxLength = -baseAddr.getOffset();
                    }
                    if (length <= maxLength) continue;
                    return "Length must not exceed maximum allowed size of " + maxLength + " (0x" + Long.toHexString(maxLength) + ") bytes";
                }
                if (optName.equals(OPTION_NAME_BLOCK_NAME)) {
                    if (String.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Block Name must be a String";
                }
                if (!optName.equals(OPTION_NAME_IS_OVERLAY)) continue;
                if (!Boolean.class.isAssignableFrom(option.getValueClass())) {
                    return "Overlay must be a boolean";
                }
                isOverlay = (Boolean)option.getValue();
            }
            catch (Exception e) {
                if (e instanceof OptionException) {
                    return e.getMessage();
                }
                return "Invalid value for " + optName + " - " + String.valueOf(option.getValue());
            }
        }
        if (fileOffset + length > origFileLength) {
            return "File Offset + Length (0x" + Long.toHexString(fileOffset + length) + ") too large; set length to 0x" + Long.toHexString(origFileLength - fileOffset);
        }
        if (fileOffset == -1L) {
            return "Invalid file offset specified";
        }
        if (length == -1L) {
            return "Invalid length specified";
        }
        if (program != null && program.getMemory().intersects(baseAddr, baseAddr.add(length - 1L)) && !isOverlay) {
            return "Memory Conflict: Use <Options...> to change the base address!";
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    private Address getBaseAddr(List<Option> options) {
        Address baseAddr = null;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(OPTION_NAME_BASE_ADDR)) continue;
                baseAddr = (Address)option.getValue();
            }
        }
        return baseAddr;
    }

    private long getLength(List<Option> options) {
        long length = 0L;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(OPTION_NAME_LEN)) continue;
                length = BinaryLoader.parseLong(option);
            }
        }
        return length;
    }

    private long getFileOffset(List<Option> options) {
        long fileOffset = 0L;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(OPTION_NAME_FILE_OFFSET)) continue;
                fileOffset = BinaryLoader.parseLong(option);
            }
        }
        return fileOffset;
    }

    private String getBlockName(List<Option> options) {
        String blockName = "";
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(OPTION_NAME_BLOCK_NAME)) continue;
                blockName = (String)option.getValue();
            }
        }
        return blockName;
    }

    private boolean isOverlay(List<Option> options) {
        boolean isOverlay = false;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(OPTION_NAME_IS_OVERLAY)) continue;
                isOverlay = (Boolean)option.getValue();
            }
        }
        return isOverlay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Loaded<Program>> loadProgram(Loader.ImporterSettings settings) throws IOException, CancelledException {
        LanguageCompilerSpecPair pair = settings.loadSpec().getLanguageCompilerSpec();
        Language importerLanguage = this.getLanguageService().getLanguage(pair.languageID);
        Address baseAddr = importerLanguage.getAddressFactory().getDefaultAddressSpace().getAddress(0L);
        Program prog = this.createProgram(baseAddr, settings);
        Loaded<Program> loaded = new Loaded<Program>(prog, settings);
        boolean success = false;
        try {
            this.loadInto(prog, settings);
            this.createDefaultMemoryBlocks(prog, settings);
            success = true;
            List<Loaded<Program>> list = List.of(loaded);
            return list;
        }
        finally {
            if (!success) {
                loaded.close();
            }
        }
    }

    @Override
    protected void loadProgramInto(Program prog, Loader.ImporterSettings settings) throws IOException, LoadException, CancelledException {
        long length = this.getLength(settings.options());
        long fileOffset = this.getFileOffset(settings.options());
        Address baseAddr = this.getBaseAddr(settings.options());
        String blockName = this.getBlockName(settings.options());
        boolean isOverlay = this.isOverlay(settings.options());
        if (length == 0L) {
            length = settings.provider().length();
        }
        length = this.clipToMemorySpace(length, settings.log(), prog);
        FileBytes fileBytes = MemoryBlockUtils.createFileBytes(prog, settings.provider(), fileOffset, length, settings.monitor());
        try {
            AddressSpace space = prog.getAddressFactory().getDefaultAddressSpace();
            if (baseAddr == null) {
                baseAddr = space.getAddress(0L);
            }
            if (blockName == null || blockName.length() == 0) {
                blockName = this.generateBlockName(prog, isOverlay, baseAddr.getAddressSpace());
            }
            this.createBlock(prog, isOverlay, blockName, baseAddr, fileBytes, length, settings.log());
        }
        catch (AddressOverflowException e) {
            throw new LoadException("Invalid address range specified: start:" + String.valueOf(baseAddr) + ", length:" + length + " - end address exceeds address space boundary!");
        }
    }

    private void createBlock(Program prog, boolean isOverlay, String blockName, Address baseAddr, FileBytes fileBytes, long length, MessageLog log) throws AddressOverflowException, IOException {
        if (prog.getMemory().intersects(baseAddr, baseAddr.add(length - 1L)) && !isOverlay) {
            throw new IOException("Can't load " + length + " bytes at address " + String.valueOf(baseAddr) + " since it conflicts with existing memory blocks!");
        }
        MemoryBlockUtils.createInitializedBlock(prog, isOverlay, blockName, baseAddr, fileBytes, 0L, length, null, "Binary Loader", true, !isOverlay, !isOverlay, log);
    }

    private long clipToMemorySpace(long length, MessageLog log, Program program) {
        AddressSpace defaultAddressSpace = program.getAddressFactory().getDefaultAddressSpace();
        long maxLength = defaultAddressSpace.getMaxAddress().getOffset() + 1L;
        if (maxLength > 0L && length > maxLength) {
            log.appendMsg("Clipped file to fit into memory space");
            length = maxLength;
        }
        return length;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram, boolean mirrorFsLayout) {
        AddressSpace defaultAddressSpace;
        Program program;
        AddressFactory addressFactory;
        long fileOffset = 0L;
        long origFileLength = -1L;
        try {
            origFileLength = provider.length();
        }
        catch (IOException e) {
            Msg.warn((Object)this, (Object)"Error determining length", (Throwable)e);
        }
        long length = origFileLength;
        boolean isOverlay = false;
        String blockName = "";
        Address baseAddr = null;
        if (domainObject instanceof Program && (addressFactory = (program = (Program)domainObject).getAddressFactory()) != null && (defaultAddressSpace = addressFactory.getDefaultAddressSpace()) != null) {
            baseAddr = defaultAddressSpace.getAddress(0L);
        }
        long tempLength = origFileLength - fileOffset;
        long len = Math.min(tempLength, origFileLength);
        length = len = Math.min(length, len);
        ArrayList<Option> list = new ArrayList<Option>();
        if (loadIntoProgram) {
            list.add(new Option(OPTION_NAME_IS_OVERLAY, isOverlay));
        } else {
            isOverlay = false;
        }
        list.add(new Option(OPTION_NAME_BLOCK_NAME, blockName, String.class, "-loader-blockName"));
        list.add(new Option(OPTION_NAME_BASE_ADDR, baseAddr, Address.class, "-loader-baseAddr"));
        list.add(new Option(OPTION_NAME_FILE_OFFSET, new HexLong(fileOffset), HexLong.class, "-loader-fileOffset"));
        list.add(new Option(OPTION_NAME_LEN, new HexLong(length), HexLong.class, "-loader-length"));
        list.addAll(super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram, mirrorFsLayout));
        return list;
    }

    @Override
    public String getName() {
        return BINARY_NAME;
    }

    @Override
    public boolean shouldApplyProcessorLabelsByDefault() {
        return true;
    }
}

