/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.matcher;

import ghidra.features.base.memsearch.bytesequence.ByteSequence;
import ghidra.features.base.memsearch.bytesequence.ExtendedByteSequence;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import java.util.Iterator;
import org.bouncycastle.util.Arrays;

public class MaskedByteSequenceByteMatcher
extends ByteMatcher {
    private final byte[] searchBytes;
    private final byte[] masks;

    public MaskedByteSequenceByteMatcher(String input, byte[] bytes, SearchSettings settings) {
        this(input, bytes, null, settings);
    }

    public MaskedByteSequenceByteMatcher(String input, byte[] bytes, byte[] masks, SearchSettings settings) {
        super("Masked Byte Sequence Matcher", input, settings);
        if (masks == null) {
            masks = new byte[bytes.length];
            Arrays.fill((byte[])masks, (byte)-1);
        }
        if (bytes.length != masks.length) {
            throw new IllegalArgumentException("Search bytes and mask bytes must be same length!");
        }
        this.searchBytes = bytes;
        this.masks = masks;
    }

    @Override
    public Iterable<ByteMatcher.ByteMatch> match(ExtendedByteSequence byteSequence) {
        return new MatchIterator(byteSequence);
    }

    @Override
    public String getDescription() {
        return this.getByteString(this.searchBytes);
    }

    @Override
    public String getToolTip() {
        return "Mask = " + this.getByteString(this.masks);
    }

    private String getByteString(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (byte b : bytes) {
            String hexString = Integer.toHexString(b & 0xFF);
            if (hexString.length() == 1) {
                buf.append("0");
            }
            buf.append(hexString);
            buf.append(" ");
        }
        return buf.toString().trim();
    }

    public byte[] getBytes() {
        return this.searchBytes;
    }

    public byte[] getMask() {
        return this.masks;
    }

    private class MatchIterator
    implements Iterator<ByteMatcher.ByteMatch>,
    Iterable<ByteMatcher.ByteMatch> {
        private ByteSequence byteSequence;
        private int startIndex = 0;
        private ByteMatcher.ByteMatch nextMatch;

        public MatchIterator(ByteSequence byteSequence) {
            this.byteSequence = byteSequence;
            this.nextMatch = this.findNextMatch();
        }

        @Override
        public Iterator<ByteMatcher.ByteMatch> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.nextMatch != null;
        }

        @Override
        public ByteMatcher.ByteMatch next() {
            if (this.nextMatch == null) {
                return null;
            }
            ByteMatcher.ByteMatch returnValue = this.nextMatch;
            this.nextMatch = this.findNextMatch();
            return returnValue;
        }

        private ByteMatcher.ByteMatch findNextMatch() {
            int nextPossibleStart = this.findNextPossibleStart(this.startIndex);
            while (nextPossibleStart >= 0) {
                this.startIndex = nextPossibleStart + 1;
                if (this.isValidMatch(nextPossibleStart)) {
                    return new ByteMatcher.ByteMatch(nextPossibleStart, MaskedByteSequenceByteMatcher.this.searchBytes.length, MaskedByteSequenceByteMatcher.this);
                }
                nextPossibleStart = this.findNextPossibleStart(this.startIndex);
            }
            return null;
        }

        private boolean isValidMatch(int possibleStart) {
            if (!this.byteSequence.hasAvailableBytes(possibleStart, MaskedByteSequenceByteMatcher.this.searchBytes.length)) {
                return false;
            }
            for (int i = 1; i < MaskedByteSequenceByteMatcher.this.searchBytes.length; ++i) {
                if (MaskedByteSequenceByteMatcher.this.searchBytes[i] == (this.byteSequence.getByte(possibleStart + i) & MaskedByteSequenceByteMatcher.this.masks[i])) continue;
                return false;
            }
            return true;
        }

        private int findNextPossibleStart(int start) {
            for (int i = start; i < this.byteSequence.getLength(); ++i) {
                if (MaskedByteSequenceByteMatcher.this.searchBytes[0] != (this.byteSequence.getByte(i) & MaskedByteSequenceByteMatcher.this.masks[0])) continue;
                return i;
            }
            return -1;
        }
    }
}

