/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.quickfix;

import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.features.base.quickfix.QuickFixStatusRenderer;
import ghidra.features.base.quickfix.TableDataLoader;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.Map;
import javax.swing.JLabel;

public class QuickFixTableModel
extends GhidraProgramTableModel<QuickFix>
implements DomainObjectListener {
    private TableDataLoader<QuickFix> tableLoader;
    private SwingUpdateManager updateManager = new SwingUpdateManager(1000, this::refreshItems);
    private QuickFixRenderer quickFixRenderer = new QuickFixRenderer();

    protected QuickFixTableModel(Program program, String modelName, ServiceProvider serviceProvider, TableDataLoader<QuickFix> loader) {
        super(modelName, serviceProvider, program, null);
        this.tableLoader = loader;
        program.addListener((DomainObjectListener)this);
    }

    @Override
    public void dispose() {
        this.updateManager.dispose();
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this);
        }
        this.program = null;
        super.dispose();
    }

    protected void doLoad(Accumulator<QuickFix> accumulator, TaskMonitor monitor) throws CancelledException {
        this.tableLoader.loadData(accumulator, monitor);
    }

    @Override
    protected TableColumnDescriptor<QuickFix> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new OriginalValueColumn(), 1, true);
        descriptor.addHiddenColumn((DynamicTableColumn)new CurrentValueColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PreviewColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ActionColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new TypeColumn(this));
        descriptor.addHiddenColumn((DynamicTableColumn)new AddressColumn(this));
        descriptor.addHiddenColumn((DynamicTableColumn)new PathColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new QuickFixStatusColumn(this));
        return descriptor;
    }

    @Override
    public ProgramLocation getProgramLocation(int modelRow, int modelColumn) {
        if (modelRow < 0 || modelRow >= this.filteredData.size()) {
            return null;
        }
        QuickFix quickFix = (QuickFix)this.filteredData.get(modelRow);
        return quickFix.getProgramLocation();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        this.updateManager.update();
    }

    private void refreshItems() {
        this.fireTableDataChanged();
    }

    public class QuickFixRenderer
    extends AbstractGhidraColumnRenderer<String> {
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            QuickFix item = (QuickFix)data.getRowObject();
            StringBuilder buf = new StringBuilder();
            buf.append("<HTML>");
            buf.append("<TABLE>");
            this.addHtmlTableRow(buf, "Action", item.getActionName() + " " + item.getItemType());
            Address address = item.getAddress();
            if (address != null && address.isMemoryAddress()) {
                this.addHtmlTableRow(buf, "Address", address.toString());
            }
            this.addCustomTableRows(buf, item.getCustomToolTipData());
            this.addHtmlTableRow(buf, "Original", item.getOriginal());
            this.addHtmlTableRow(buf, "Preview", item.getPreview());
            this.addHtmlTableRow(buf, "Current", item.getCurrent());
            buf.append("</TABLE></HTML>");
            renderer.setToolTipText(buf.toString());
            return renderer;
        }

        private void addCustomTableRows(StringBuilder buf, Map<String, String> dataMap) {
            if (dataMap == null) {
                return;
            }
            for (Map.Entry<String, String> entry : dataMap.entrySet()) {
                this.addHtmlTableRow(buf, entry.getKey(), entry.getValue());
            }
        }

        private void addHtmlTableRow(StringBuilder buf, String name, String value) {
            buf.append("<TR><TD><B>");
            buf.append(HTMLUtilities.escapeHTML((String)name));
            buf.append(":</B></TD><TD>");
            buf.append(HTMLUtilities.escapeHTML((String)value));
            buf.append("</TD></TR>");
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    }

    private class OriginalValueColumn
    extends AbstractDynamicTableColumnStub<QuickFix, String> {
        private OriginalValueColumn() {
        }

        public String getColumnName() {
            return "Original";
        }

        public int getColumnPreferredWidth() {
            return 150;
        }

        public String getValue(QuickFix rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getOriginal();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return QuickFixTableModel.this.quickFixRenderer;
        }
    }

    private class CurrentValueColumn
    extends AbstractDynamicTableColumnStub<QuickFix, String> {
        private CurrentValueColumn() {
        }

        public String getColumnName() {
            return "Current";
        }

        public int getColumnPreferredWidth() {
            return 150;
        }

        public String getValue(QuickFix rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getCurrent();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return QuickFixTableModel.this.quickFixRenderer;
        }
    }

    private class PreviewColumn
    extends AbstractDynamicTableColumnStub<QuickFix, String> {
        private PreviewColumn() {
        }

        public String getColumnName() {
            return "Preview";
        }

        public int getColumnPreferredWidth() {
            return 150;
        }

        public String getValue(QuickFix rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getPreview();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return QuickFixTableModel.this.quickFixRenderer;
        }
    }

    private class ActionColumn
    extends AbstractDynamicTableColumnStub<QuickFix, String> {
        private ActionColumn(QuickFixTableModel quickFixTableModel) {
        }

        public String getColumnName() {
            return "Action";
        }

        public int getColumnPreferredWidth() {
            return 75;
        }

        public String getValue(QuickFix rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getActionName();
        }
    }

    private class TypeColumn
    extends AbstractDynamicTableColumnStub<QuickFix, String> {
        private TypeColumn(QuickFixTableModel quickFixTableModel) {
        }

        public String getColumnName() {
            return "Type";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public String getValue(QuickFix rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getItemType();
        }
    }

    private class AddressColumn
    extends AbstractDynamicTableColumnStub<QuickFix, Address> {
        private AddressColumn(QuickFixTableModel quickFixTableModel) {
        }

        public String getColumnName() {
            return "Address";
        }

        public int getColumnPreferredWidth() {
            return 50;
        }

        public Address getValue(QuickFix rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getAddress();
        }
    }

    private class PathColumn
    extends AbstractDynamicTableColumnStub<QuickFix, String> {
        private PathColumn(QuickFixTableModel quickFixTableModel) {
        }

        public String getColumnName() {
            return "Path";
        }

        public int getColumnPreferredWidth() {
            return 150;
        }

        public String getValue(QuickFix rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getPath();
        }
    }

    private class QuickFixStatusColumn
    extends AbstractDynamicTableColumnStub<QuickFix, QuickFixStatus> {
        QuickFixStatusRenderer renderer = new QuickFixStatusRenderer();

        private QuickFixStatusColumn(QuickFixTableModel quickFixTableModel) {
        }

        public String getColumnName() {
            return "Status";
        }

        public int getColumnPreferredWidth() {
            return 25;
        }

        public QuickFixStatus getValue(QuickFix rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getStatus();
        }

        public GColumnRenderer<QuickFixStatus> getColumnRenderer() {
            return this.renderer;
        }
    }
}

