/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileByteProvider;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileCache;
import ghidra.formats.gfilesystem.FileCacheNameIndex;
import ghidra.formats.gfilesystem.FileSystemInstanceManager;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileHashProvider;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.LocalFileSystem;
import ghidra.formats.gfilesystem.RefdByteProvider;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.formats.gfilesystem.crypto.CryptoProviderSessionChildImpl;
import ghidra.formats.gfilesystem.crypto.CryptoProviders;
import ghidra.formats.gfilesystem.crypto.CryptoSession;
import ghidra.formats.gfilesystem.factory.FileSystemFactoryMgr;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.timer.GTimer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class FileSystemService {
    private static FileSystemService instance;
    private final LocalFileSystem localFS = LocalFileSystem.makeGlobalRootFS();
    private final FileSystemFactoryMgr fsFactoryMgr = FileSystemFactoryMgr.getInstance();
    private final FSRLRoot cacheFSRL = FSRLRoot.makeRoot("cache");
    private final FileCache fileCache;
    private final FileSystemInstanceManager fsInstanceManager = new FileSystemInstanceManager(this.localFS);
    private final FileCacheNameIndex fileCacheNameIndex = new FileCacheNameIndex();
    private long fsCacheMaintIntervalMS = 10000L;
    private CryptoSession currentCryptoSession;

    public static synchronized FileSystemService getInstance() {
        if (instance == null) {
            instance = new FileSystemService();
        }
        return instance;
    }

    public static synchronized boolean isInitialized() {
        return instance != null;
    }

    public FileSystemService() {
        this(new File(Application.getUserCacheDirectory(), "fscache2"));
        FileCache.performCacheMaintOnOldDirIfNeeded(new File(Application.getUserCacheDirectory(), "fscache"));
    }

    public FileSystemService(File fscacheDir) {
        try {
            this.fileCache = new FileCache(fscacheDir);
            GTimer.scheduleRepeatingRunnable((long)this.fsCacheMaintIntervalMS, (long)this.fsCacheMaintIntervalMS, () -> this.fsInstanceManager.cacheMaint());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to init global cache " + String.valueOf(fscacheDir), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        FileSystemInstanceManager fileSystemInstanceManager = this.fsInstanceManager;
        synchronized (fileSystemInstanceManager) {
            this.fsInstanceManager.clear();
            this.fileCacheNameIndex.clear();
        }
    }

    public void closeUnusedFileSystems() {
        this.fsInstanceManager.closeAllUnused();
    }

    public void releaseFileSystemImmediate(FileSystemRef fsRef) {
        if (fsRef != null && !fsRef.isClosed()) {
            this.fsInstanceManager.releaseImmediate(fsRef);
        }
    }

    public LocalFileSystem getLocalFS() {
        return this.localFS;
    }

    public boolean isLocal(FSRL fsrl) {
        return this.localFS.isSameFS(fsrl);
    }

    public FSRL getLocalFSRL(File f) {
        return this.localFS.getLocalFSRL(f);
    }

    public boolean isFilesystemMountedAt(FSRL fsrl) {
        return this.fsInstanceManager.isFilesystemMountedAt(fsrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefdFile getRefdFile(FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        try (FileSystemRef ref = this.getFilesystem(fsrl.getFS(), monitor);){
            GFile gfile = ref.getFilesystem().lookup(fsrl.getPath());
            if (gfile == null) {
                throw new IOException("File [%s] not found in filesystem [%s]".formatted(fsrl.getPath(), ref.getFilesystem().getFSRL()));
            }
            RefdFile result = new RefdFile(ref, gfile);
            ref = null;
            RefdFile refdFile = result;
            return refdFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemRef getFilesystem(FSRLRoot fsFSRL, TaskMonitor monitor) throws IOException, CancelledException {
        FileSystemInstanceManager fileSystemInstanceManager = this.fsInstanceManager;
        synchronized (fileSystemInstanceManager) {
            FileSystemRef ref = this.fsInstanceManager.getRef(fsFSRL);
            if (ref == null) {
                if (!fsFSRL.hasContainer()) {
                    throw new IOException("Bad FSRL " + String.valueOf(fsFSRL));
                }
                ByteProvider containerByteProvider = this.getByteProvider(fsFSRL.getContainer(), true, monitor);
                GFileSystem fs = this.fsFactoryMgr.mountFileSystem(fsFSRL.getProtocol(), containerByteProvider, this, monitor);
                ref = fs.getRefManager().create();
                this.fsInstanceManager.add(fs);
            }
            return ref;
        }
    }

    public ByteProvider getByteProvider(FSRL fsrl, boolean fullyQualifiedFSRL, TaskMonitor monitor) throws CancelledException, IOException {
        FileCache.FileCacheEntry fce;
        if (fsrl.getMD5() != null && (fce = this.fileCache.getFileCacheEntry(fsrl.getMD5())) != null) {
            return fce.asByteProvider(fsrl);
        }
        try (FileSystemRef fsRef = this.getFilesystem(fsrl.getFS(), monitor);){
            FileCache.FileCacheEntry fce2;
            GFileSystem fs = fsRef.getFilesystem();
            GFile file = fs.lookup(fsrl.getPath());
            if (file == null) {
                throw new IOException("File not found: " + String.valueOf(fsrl));
            }
            if (file.getFSRL().getMD5() != null && (fce2 = this.fileCache.getFileCacheEntry((fsrl = file.getFSRL()).getMD5())) != null) {
                ByteProvider byteProvider = fce2.asByteProvider(fsrl);
                return byteProvider;
            }
            ByteProvider provider = fs.getByteProvider(file, monitor);
            if (provider == null) {
                throw new IOException("Unable to get ByteProvider for " + String.valueOf(fsrl));
            }
            FSRL resultFSRL = provider.getFSRL();
            if (resultFSRL.getMD5() == null && (fsrl.getMD5() != null || fullyQualifiedFSRL)) {
                String md5 = fs instanceof GFileHashProvider ? ((GFileHashProvider)((Object)fs)).getMD5Hash(file, true, monitor) : FSUtilities.getMD5(provider, monitor);
                resultFSRL = resultFSRL.withMD5(md5);
            }
            if (fsrl.getMD5() != null && !fsrl.isMD5Equal(resultFSRL.getMD5())) {
                throw new IOException("Unable to retrieve requested file, hash has changed: " + String.valueOf(fsrl) + ", new hash: " + resultFSRL.getMD5());
            }
            RefdByteProvider refdByteProvider = new RefdByteProvider(fsRef.dup(), provider, resultFSRL);
            return refdByteProvider;
        }
    }

    public ByteProvider getDerivedByteProvider(FSRL containerFSRL, FSRL derivedFSRL, String derivedName, long sizeHint, DerivedStreamProducer producer, TaskMonitor monitor) throws CancelledException, IOException {
        this.assertFullyQualifiedFSRL(containerFSRL);
        String containerMD5 = containerFSRL.getMD5();
        String derivedMD5 = this.fileCacheNameIndex.get(containerMD5, derivedName);
        FileCache.FileCacheEntry derivedFile = this.fileCache.getFileCacheEntry(derivedMD5);
        if (derivedFile == null) {
            monitor.setMessage("Caching " + containerFSRL.getName() + " " + derivedName);
            if (sizeHint > 0L) {
                monitor.initialize(sizeHint);
            }
            try (InputStream is = producer.produceDerivedStream();
                 FileCache.FileCacheEntryBuilder fceBuilder = this.fileCache.createCacheEntryBuilder(sizeHint);){
                FSUtilities.streamCopy(is, fceBuilder, monitor);
                derivedFile = fceBuilder.finish();
                this.fileCacheNameIndex.add(containerMD5, derivedName, derivedFile.getMD5());
            }
        }
        derivedFSRL = derivedFSRL != null ? derivedFSRL.withMD5(derivedFile.getMD5()) : this.createCachedFileFSRL(derivedFile.getMD5());
        return derivedFile.asByteProvider(derivedFSRL);
    }

    public ByteProvider getDerivedByteProviderPush(FSRL containerFSRL, FSRL derivedFSRL, String derivedName, long sizeHint, DerivedStreamPushProducer pusher, TaskMonitor monitor) throws CancelledException, IOException {
        this.assertFullyQualifiedFSRL(containerFSRL);
        String containerMD5 = containerFSRL.getMD5();
        String derivedMD5 = this.fileCacheNameIndex.get(containerMD5, derivedName);
        FileCache.FileCacheEntry derivedFile = this.fileCache.getFileCacheEntry(derivedMD5);
        if (derivedFile == null) {
            monitor.setMessage("Caching " + containerFSRL.getName() + " " + derivedName);
            if (sizeHint > 0L) {
                monitor.initialize(sizeHint);
            }
            try (FileCache.FileCacheEntryBuilder fceBuilder = this.fileCache.createCacheEntryBuilder(sizeHint);){
                pusher.push(fceBuilder);
                derivedFile = fceBuilder.finish();
            }
            this.fileCacheNameIndex.add(containerMD5, derivedName, derivedFile.getMD5());
        }
        derivedFSRL = derivedFSRL != null ? derivedFSRL.withMD5(derivedFile.getMD5()) : this.createCachedFileFSRL(derivedFile.getMD5());
        return derivedFile.asByteProvider(derivedFSRL);
    }

    private FSRL createCachedFileFSRL(String md5) {
        return this.cacheFSRL.withPathMD5("/" + md5, md5);
    }

    public FileCache.FileCacheEntryBuilder createTempFile(long sizeHint) throws IOException {
        return this.fileCache.createCacheEntryBuilder(sizeHint);
    }

    public ByteProvider getNamedTempFile(FileCache.FileCacheEntry tempFileCacheEntry, String name) throws IOException {
        FSRL resultFSRL = FSRLRoot.makeRoot("tmp").withPathMD5(FSUtilities.appendPath("/", name), tempFileCacheEntry.getMD5());
        return tempFileCacheEntry.asByteProvider(resultFSRL);
    }

    public File getFileIfAvailable(ByteProvider provider) {
        if (provider instanceof RefdByteProvider) {
            provider = ((RefdByteProvider)provider).getWrappedByteProvider();
        }
        if (provider instanceof FileByteProvider || provider instanceof RandomAccessByteProvider) {
            return provider.getFile();
        }
        return null;
    }

    public File createPlaintextTempFile(ByteProvider provider, String filenamePrefix, TaskMonitor monitor) throws IOException {
        File tmpFile = Application.createTempFile((String)filenamePrefix, (String)Long.toString(System.currentTimeMillis()));
        monitor.setMessage("Copying " + provider.getName() + " to temp file");
        monitor.initialize(provider.length());
        try {
            FSUtilities.copyByteProviderToFile(provider, tmpFile, monitor);
        }
        catch (CancelledException e) {
            throw new IOException("Copy was cancelled: " + provider.getName());
        }
        return tmpFile;
    }

    public void releaseFileCache(FSRL fsrl) {
        if (fsrl.getMD5() != null) {
            this.fileCache.releaseFileCacheEntry(fsrl.getMD5());
        }
    }

    public ByteProvider pushFileToCache(File file, FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        FileCache.FileCacheEntry fce = this.fileCache.giveFile(file, monitor);
        return fce.asByteProvider(fsrl);
    }

    public boolean hasDerivedFile(FSRL containerFSRL, String derivedName, TaskMonitor monitor) throws CancelledException, IOException {
        this.assertFullyQualifiedFSRL(containerFSRL);
        String containerMD5 = containerFSRL.getMD5();
        String derivedMD5 = this.fileCacheNameIndex.get(containerMD5, derivedName);
        return derivedMD5 != null && this.fileCache.hasEntry(derivedMD5);
    }

    public boolean isFileFilesystemContainer(FSRL containerFSRL, TaskMonitor monitor) throws CancelledException, IOException {
        try (ByteProvider byteProvider = this.getByteProvider(containerFSRL, false, monitor);){
            boolean bl = this.fsFactoryMgr.test(byteProvider, this, monitor);
            return bl;
        }
    }

    public FileSystemRef probeFileForFilesystem(FSRL containerFSRL, TaskMonitor monitor, FileSystemProbeConflictResolver conflictResolver) throws CancelledException, IOException {
        return this.probeFileForFilesystem(containerFSRL, monitor, conflictResolver, Integer.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemRef probeFileForFilesystem(FSRL containerFSRL, TaskMonitor monitor, FileSystemProbeConflictResolver conflictResolver, int priorityFilter) throws CancelledException, IOException {
        FileSystemInstanceManager fileSystemInstanceManager = this.fsInstanceManager;
        synchronized (fileSystemInstanceManager) {
            FileSystemRef ref = this.fsInstanceManager.getFilesystemRefMountedAt(containerFSRL);
            if (ref != null) {
                return ref;
            }
        }
        try {
            ByteProvider byteProvider = this.getByteProvider(containerFSRL, true, monitor);
            GFileSystem fs = this.fsFactoryMgr.probe(byteProvider, this, conflictResolver, priorityFilter, monitor);
            if (fs != null) {
                FileSystemInstanceManager fileSystemInstanceManager2 = this.fsInstanceManager;
                synchronized (fileSystemInstanceManager2) {
                    FileSystemRef fsRef = this.fsInstanceManager.getFilesystemRefMountedAt(fs.getFSRL());
                    if (fsRef != null) {
                        fs.close();
                        return fsRef;
                    }
                    this.fsInstanceManager.add(fs);
                    return fs.getRefManager().create();
                }
            }
        }
        catch (IOException ioe) {
            Msg.trace((Object)this, (Object)"Probe exception", (Throwable)ioe);
            throw ioe;
        }
        return null;
    }

    public <FSTYPE extends GFileSystem> FSTYPE mountSpecificFileSystem(FSRL containerFSRL, Class<FSTYPE> fsClass, TaskMonitor monitor) throws CancelledException, IOException {
        String fsType = this.fsFactoryMgr.getFileSystemType(fsClass);
        if (fsType == null) {
            Msg.error((Object)this, (Object)("Specific file system implemention " + fsClass.getName() + " not registered correctly in file system factory."));
            return null;
        }
        ByteProvider byteProvider = this.getByteProvider(containerFSRL, true, monitor);
        GFileSystem fs = this.fsFactoryMgr.mountFileSystem(fsType, byteProvider, this, monitor);
        Class<?> producedClass = fs.getClass();
        if (!fsClass.isAssignableFrom(fs.getClass())) {
            fs.close();
            throw new IOException("Bad file system type returned by factory. Expecting " + fsClass.getName() + " but factory produced " + producedClass.getName());
        }
        return (FSTYPE)((GFileSystem)fsClass.cast(fs));
    }

    public GFileSystem openFileSystemContainer(FSRL containerFSRL, TaskMonitor monitor) throws CancelledException, IOException {
        ByteProvider byteProvider = this.getByteProvider(containerFSRL, true, monitor);
        return this.fsFactoryMgr.probe(byteProvider, this, null, Integer.MIN_VALUE, monitor);
    }

    public FSRL getFullyQualifiedFSRL(FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        if (fsrl == null || fsrl.getMD5() != null) {
            return fsrl;
        }
        try (FileSystemRef fsRef = this.getFilesystem(fsrl.getFS(), monitor);){
            FSRL fSRL = this.getFullyQualifiedFSRL(fsRef.getFilesystem(), fsrl, monitor);
            return fSRL;
        }
    }

    private void assertFullyQualifiedFSRL(FSRL fsrl) throws IOException {
        if (fsrl.getMD5() == null) {
            throw new IOException("Bad FSRL, expected fully qualified: " + String.valueOf(fsrl));
        }
    }

    private FSRL getFullyQualifiedFSRL(GFileSystem fs, FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        String md5;
        if (fsrl.getMD5() != null) {
            return fsrl;
        }
        GFile file = fs.lookup(fsrl.getPath());
        if (file == null) {
            throw new IOException("File not found: " + String.valueOf(fsrl));
        }
        if (file.getFSRL().getMD5() != null || file.isDirectory()) {
            return file.getFSRL();
        }
        FSRL containerFSRL = fsrl.getFS().getContainer();
        if (containerFSRL != null && containerFSRL.getMD5() == null) {
            containerFSRL = fs.getFSRL().getContainer();
            fsrl = FSRLRoot.nestedFS(containerFSRL, fsrl.getFS()).withPath(fsrl);
        }
        if (fs instanceof GFileHashProvider) {
            GFileHashProvider hashProvider = (GFileHashProvider)((Object)fs);
            return fsrl.withMD5(hashProvider.getMD5Hash(file, true, monitor));
        }
        String string = md5 = containerFSRL != null ? this.fileCacheNameIndex.get(containerFSRL.getMD5(), fsrl.getPath()) : null;
        if (md5 == null) {
            try (ByteProvider bp = fs.getByteProvider(file, monitor);){
                if (bp == null) {
                    throw new IOException("Unable to get bytes for " + String.valueOf(fsrl));
                }
                md5 = bp.getFSRL().getMD5() != null ? bp.getFSRL().getMD5() : FSUtilities.getMD5(bp, monitor);
            }
        }
        if (containerFSRL != null && fs.isStatic()) {
            this.fileCacheNameIndex.add(containerFSRL.getMD5(), fsrl.getPath(), md5);
        }
        return fsrl.withMD5(md5);
    }

    public List<String> getAllFilesystemNames() {
        return FileSystemFactoryMgr.getInstance().getAllFilesystemNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FSRLRoot> getMountedFilesystems() {
        FileSystemInstanceManager fileSystemInstanceManager = this.fsInstanceManager;
        synchronized (fileSystemInstanceManager) {
            return this.fsInstanceManager.getMountedFilesystems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemRef getMountedFilesystem(FSRLRoot fsFSRL) {
        FileSystemInstanceManager fileSystemInstanceManager = this.fsInstanceManager;
        synchronized (fileSystemInstanceManager) {
            return this.fsInstanceManager.getRef(fsFSRL);
        }
    }

    public synchronized CryptoSession newCryptoSession() {
        if (this.currentCryptoSession == null || this.currentCryptoSession.isClosed()) {
            this.currentCryptoSession = CryptoProviders.getInstance().newSession();
            return this.currentCryptoSession;
        }
        return new CryptoProviderSessionChildImpl(this.currentCryptoSession);
    }

    public static interface DerivedStreamProducer {
        public InputStream produceDerivedStream() throws IOException, CancelledException;
    }

    public static interface DerivedStreamPushProducer {
        public void push(OutputStream var1) throws IOException, CancelledException;
    }
}

