
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was GinkgoConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(GINKGO_PROJECT_NAME "Ginkgo")
set(GINKGO_PROJECT_VERSION 1.9.0)
set(GINKGO_PROJECT_DESCRIPTION "A numerical linear algebra library targeting many-core architectures")

# Extra version information
set(GINKGO_VERSION_MAJOR 1)
set(GINKGO_VERSION_MINOR 9)
set(GINKGO_VERSION_PATCH 0)

# Git information
set(GINKGO_GIT_BRANCH "")
set(GINKGO_GIT_REVISION "")
set(GINKGO_GIT_SHORTREV "")

# CMake build configuration
set(GINKGO_BUILD_TYPE "Release")
set(GINKGO_BUILD_SHARED_LIBS "ON")
set(GINKGO_DEBUG_POSTFIX "d")

# Compiler configuration
set(GINKGO_CXX_COMPILER "/opt/local/bin/mpicxx-mpich-clang11")
set(GINKGO_CXX_COMPILER_VERSION 11.1.0)

set(GINKGO_CXX_FLAGS "-pipe -Os -DNDEBUG -I/opt/local/include -stdlib=libc++")
set(GINKGO_CXX_FLAGS_DEBUG "-g")
set(GINKGO_CXX_FLAGS_RELEASE "-O3 -DNDEBUG")

set(GINKGO_EXE_LINKER_FLAGS "-L/opt/local/lib -Wl,-headerpad_max_install_names -Wl,-rpath,/opt/local/lib/libgcc")
set(GINKGO_EXE_LINKER_FLAGS_DEBUG "")
set(GINKGO_EXE_LINKER_FLAGS_RELEASE "")

# Ginkgo configuration
set(GINKGO_BUILD_REFERENCE ON)
set(GINKGO_BUILD_OMP OFF)
set(GINKGO_BUILD_CUDA OFF)
set(GINKGO_BUILD_HIP OFF)
set(GINKGO_BUILD_MPI ON)
set(GINKGO_BUILD_SYCL OFF)

set(GINKGO_DEVEL_TOOLS OFF)
set(GINKGO_BUILD_TESTS OFF)
set(GINKGO_BUILD_EXAMPLES OFF)
set(GINKGO_BUILD_EXTLIB_EXAMPLE )
set(GINKGO_BUILD_BENCHMARKS OFF)

set(GINKGO_BUILD_DOC OFF)
set(GINKGO_DOC_GENERATE_EXAMPLES OFF)
set(GINKGO_DOC_GENERATE_PDF OFF)
set(GINKGO_DOC_GENERATE_DEV )

set(GINKGO_SKIP_DEPENDENCY_UPDATE ON)
set(GINKGO_VERBOSE_LEVEL 1)

set(GINKGO_WITH_CLANG_TIDY OFF)
set(GINKGO_WITH_IWYU OFF)
set(GINKGO_CLANG_TIDY_PATH )
set(GINKGO_IWYU_PATH )

set(GINKGO_JACOBI_FULL_OPTIMIZATIONS OFF)

set(GINKGO_CUDA_ARCHITECTURES "")
set(GINKGO_CUDA_HOST_COMPILER "")

set(GINKGO_HIP_COMPILER_FLAGS "")
set(GINKGO_HIP_PLATFORM "")
set(GINKGO_HIP_VERSION "")
set(GINKGO_HIP_ARCHITECTURES "")

set(GINKGO_DPCPP_VERSION )
set(GINKGO_DPCPP_MAJOR_VERSION 0)
set(GINKGO_DPCPP_FLAGS "")
set(GINKGO_MKL_ROOT "")
set(GINKGO_DPL_ROOT "")

set(GINKGO_BUILD_MPI ON)

set(GINKGO_HAVE_PAPI_SDE 0)

set(GINKGO_HAVE_HWLOC 0)

set(GINKGO_HAVE_ROCTX 0)

# Ginkgo compiler information
set(GINKGO_CXX_COMPILER "/opt/local/bin/mpicxx-mpich-clang11")
set(GINKGO_CXX_COMPILER_SHORT "Clang:11.1.0")
set(GINKGO_CUDA_COMPILER "")
set(GINKGO_CUDA_COMPILER_SHORT ":")
set(GINKGO_CUDA_HOST_COMPILER "")
set(GINKGO_CUDA_HOST_COMPILER_SHORT "")  # dummy value to stay consistent

# Ginkgo installation configuration
set(GINKGO_EXPORT_BINARY_DIR "OFF")
if(NOT GINKGO_EXPORT_BINARY_DIR)
    set_and_check(GINKGO_INSTALL_PREFIX "${PACKAGE_PREFIX_DIR}")
    set_and_check(GINKGO_INSTALL_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
    set_and_check(GINKGO_INSTALL_LIBRARY_DIR "${PACKAGE_PREFIX_DIR}/lib")
    set(GINKGO_INSTALL_RPATH_FOR_HIP "-Wl,-rpath,${GINKGO_INSTALL_LIBRARY_DIR}")
    set(GINKGO_INSTALL_RPATH ON)
    set(GINKGO_INSTALL_RPATH_USE_ORIGIN )
    set(GINKGO_INSTALL_RPATH_DEPENDENCIES OFF)
endif()

# Forward Ginkgo's MODULE PATH and the PREFIX PATH for HIP and more
set_and_check(GINKGO_INSTALL_MODULE_DIR "${PACKAGE_PREFIX_DIR}/lib/cmake/Ginkgo/Modules")
list(APPEND CMAKE_MODULE_PATH "${GINKGO_INSTALL_MODULE_DIR}")
if(GINKGO_BUILD_HIP)
    list(APPEND CMAKE_MODULE_PATH "")
endif()

set(GINKGO_INTERFACE_LINK_LIBRARIES "ginkgo_device;ginkgo_omp;ginkgo_cuda;ginkgo_reference;ginkgo_hip;ginkgo_dpcpp;MPI::MPI_CXX")
set(GINKGO_INTERFACE_LINK_FLAGS "-L\${prefix}/lib;-lginkgo$<$<CONFIG:Debug>:d>;-lginkgo_device$<$<CONFIG:Debug>:d>;-lginkgo_omp$<$<CONFIG:Debug>:d>;-lginkgo_cuda$<$<CONFIG:Debug>:d>;-lginkgo_reference$<$<CONFIG:Debug>:d>;-lginkgo_hip$<$<CONFIG:Debug>:d>;-lginkgo_dpcpp$<$<CONFIG:Debug>:d>")
set(GINKGO_INTERFACE_CXX_FLAGS "-I\${prefix}/include")

# CUDA
set(GINKGO_CUDA_COMPILER "")
set(GINKGO_CUDA_COMPILER_VERSION )
set(GINKGO_CUDA_HOST_LINK_LAUNCHER "")

set(GINKGO_CUDA_FLAGS "")
set(GINKGO_CUDA_FLAGS_DEBUG "")
set(GINKGO_CUDA_FLAGS_RELEASE "")

# OpenMP
set(GINKGO_OPENMP_VERSION )

set(GINKGO_OPENMP_LIB_NAMES "")
set(GINKGO_OPENMP_LIBRARIES "")

set(GINKGO_OPENMP_FLAGS "")

set(GINKGO_HAVE_TAU "0")
set(GINKGO_HAVE_VTUNE "0")
set(GINKGO_HAVE_METIS "1")
set_and_check(VTune_PATH "/..")

# ensure Threads settings
set(THREADS_PREFER_PTHREAD_FLAG ON)

# NOTE: we do not export benchmarks, examples, tests or devel tools
#     so `third_party` libraries are currently unneeded.

include(CMakeFindDependencyMacro)
if(GINKGO_HAVE_PAPI_SDE)
    find_dependency(PAPI 7.0.1.0 COMPONENTS sde)
endif()

if(GINKGO_HAVE_HWLOC)
    find_dependency(HWLOC)
endif()

# Check for MPI if it is enabled
if(GINKGO_BUILD_MPI)
    find_dependency(MPI 3.1 COMPONENTS CXX)
endif()

# HIP and OpenMP depend on Threads::Threads in some circumstances, but don't find it
if (GINKGO_BUILD_HIP OR GINKGO_BUILD_OMP)
    find_dependency(Threads)
endif()

# Needed because of a known issue with CUDA while linking statically.
# For details, see https://gitlab.kitware.com/cmake/cmake/issues/18614
if((NOT GINKGO_BUILD_SHARED_LIBS) AND GINKGO_BUILD_CUDA)
    enable_language(CUDA)
    find_dependency(CUDAToolkit)
    find_dependency(NVTX)
endif()

if((NOT GINKGO_BUILD_SHARED_LIBS) AND GINKGO_BUILD_HIP)
    enable_language(HIP)
    find_dependency(hipblas)
    find_dependency(hipfft)
    find_dependency(hiprand)
    find_dependency(hipsparse)
    find_dependency(rocrand)
    find_dependency(rocthrust)
    find_dependency(ROCTX)
endif()

if((NOT GINKGO_BUILD_SHARED_LIBS) AND GINKGO_BUILD_SYCL)
    find_dependency(MKL CONFIG HINTS "${GINKGO_MKL_ROOT}")
    find_dependency(oneDPL HINTS "${GINKGO_DPL_ROOT}")
endif()

if(GINKGO_HAVE_VTUNE)
    find_dependency(VTune)
endif()

if((NOT GINKGO_BUILD_SHARED_LIBS) AND GINKGO_HAVE_METIS)
    find_dependency(METIS)
endif()

if((NOT GINKGO_BUILD_SHARED_LIBS) AND GINKGO_HAVE_TAU)
    find_dependency(PerfStubs)
endif()

# Check that the same compilers as for Ginkgo are used
function(_ginkgo_check_compiler lang)
    if(DEFINED CMAKE_${lang}_COMPILER AND (NOT "${CMAKE_${lang}_COMPILER}" STREQUAL "${GINKGO_${lang}_COMPILER}"))
        set(_compiler_short "${CMAKE_${lang}_COMPILER_ID}:${CMAKE_${lang}_COMPILER_VERSION}")
        if(NOT "${_compiler_short}" STREQUAL "${GINKGO_${lang}_COMPILER_SHORT}")
            message(WARNING "The currently used ${lang} compiler: ${CMAKE_${lang}_COMPILER} does not match the compiler used to "
                            "build Ginkgo: ${GINKGO_${lang}_COMPILER}. It is encouraged to use the same compiler as Ginkgo to prevent ABI mismatch.")
        endif()
    endif()
endfunction()
_ginkgo_check_compiler(CXX)
if(GINKGO_BUILD_CUDA)
    _ginkgo_check_compiler(CUDA)
    _ginkgo_check_compiler(CUDA_HOST)
endif()
if(GINKGO_BUILD_HIP)
    _ginkgo_check_compiler(HIP)
endif()

include(${CMAKE_CURRENT_LIST_DIR}/GinkgoTargets.cmake)

check_required_components(Ginkgo)
